﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using App = LayoutEditor;

    /// <summary>
    /// マテリアルＴＥＶページクラス。
    /// </summary>
    public sealed class MaterialTevPage : MaterialPage
    {
        #region デザイナ変数

        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            //
            // MaterialTevPage
            //
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Name = "MaterialTevPage";
            this.Size = new System.Drawing.Size(360, 320);

        }
        #endregion

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialTevPage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
             PropertyPage page = new MaterialTevPage();

            page.Enabled = false;

            return page;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override PropertyPageID PageID
        {
            get { return PropertyPageID.MaterialTev; }
        }



        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void InitializeProperty()
        {
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void DoUpdateProperty_()
        {
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

      #region コピー＆ペースト
      /// <summary>
      /// コピーが可能か。
      /// </summary>
      public override bool CanCopy() { return false; }

        /// <summary>
        /// コピー。
        /// </summary>
        public override Object Copy()
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static Object Copy(MaterialGUIAdapter target)
        {
            ArrayList data = new ArrayList();
            return data;
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(Object pasteObject)
        {
            Paste(ActiveTarget, pasteObject);
            using (new GUIUpdating(this))
            {
                UpdateProperty();
            }
            NotifyPropertyChanged();
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static void Paste(MaterialGUIAdapter destination, Object pasteObject)
        {
            Debug.Assert(pasteObject is ArrayList);
            ArrayList source = (ArrayList)pasteObject;
            Debug.Assert(source.Count == 4);
        }
        #endregion

    }
}
