﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.GroupWindow
{
    using LECore;
    using LECore.Structures;
    using LECore.Manipulator;
    using LayoutEditor.Controls;

    /// <summary>
    /// PaneGroupEditDlg の概要の説明です。
    /// </summary>
    public class GroupEditDlg : System.Windows.Forms.Form
    {
        #region デザイナ変数
        private System.Windows.Forms.Button _btnOK;
        private System.Windows.Forms.Button _btnCancel;
        private System.Windows.Forms.Label _lblGroupName;
        private System.Windows.Forms.Label _lblComment;
        private LayoutEditor.Controls.StringTextBox _tbxGroupName;
        private System.Windows.Forms.TextBox        _tbxComment;
        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;

        #endregion デザイナ変数

        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(GroupEditDlg));
            this._btnOK = new System.Windows.Forms.Button();
            this._btnCancel = new System.Windows.Forms.Button();
            this._lblGroupName = new System.Windows.Forms.Label();
            this._lblComment = new System.Windows.Forms.Label();
            this._tbxGroupName = new LayoutEditor.Controls.StringTextBox();
            this._tbxComment = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            //
            // _btnOK
            //
            resources.ApplyResources(this._btnOK, "_btnOK");
            this._btnOK.Name = "_btnOK";
            this._btnOK.Click += new System.EventHandler(this.Event_BtnOK_Click);
            //
            // _btnCancel
            //
            resources.ApplyResources(this._btnCancel, "_btnCancel");
            this._btnCancel.Name = "_btnCancel";
            this._btnCancel.Click += new System.EventHandler(this.Event_BtnCancel_Click);
            //
            // _lblGroupName
            //
            resources.ApplyResources(this._lblGroupName, "_lblGroupName");
            this._lblGroupName.Name = "_lblGroupName";
            //
            // _lblComment
            //
            resources.ApplyResources(this._lblComment, "_lblComment");
            this._lblComment.Name = "_lblComment";
            //
            // _tbxGroupName
            //
            resources.ApplyResources(this._tbxGroupName, "_tbxGroupName");
            this._tbxGroupName.Name = "_tbxGroupName";
            this._tbxGroupName.ValueChanged += new System.EventHandler(this.Event_TbxGroupName_ValueChanged);
            this._tbxGroupName.TextChanged += new System.EventHandler(this.Event_TbxGroupName_OnTextChanged);
            //
            // _tbxComment
            //
            this._tbxComment.BackColor = System.Drawing.SystemColors.Window;
            this._tbxComment.CausesValidation = false;
            resources.ApplyResources(this._tbxComment, "_tbxComment");
            this._tbxComment.Name = "_tbxComment";
            this._tbxComment.TextChanged += new System.EventHandler(this.Event_TbxComment_TextChanged);
            //
            // GroupEditDlg
            //
            resources.ApplyResources(this, "$this");
            this.Controls.Add(this._tbxComment);
            this.Controls.Add(this._tbxGroupName);
            this.Controls.Add(this._lblGroupName);
            this.Controls.Add(this._btnOK);
            this.Controls.Add(this._btnCancel);
            this.Controls.Add(this._lblComment);
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.Name = "GroupEditDlg";
            this.ResumeLayout(false);
            this.PerformLayout();

        }
        #endregion

        #region フィールド
        ILEGroup          _targetGroup = null;

        #endregion フィールド



        #region プロパティ

        public ILEGroup   TargetGroup
        {
            set
            {
                _targetGroup = value;
                UpdateProperty_();
            }
        }

        ILEGroupMgr _ILEGroupMgr
        {
            get
            {
                return LayoutEditorCore.Scene.CurrentISubScene.ILEGroupMgr;
            }
        }

        #endregion プロパティ

        /// <summary>
        /// UIを更新します。
        /// </summary>
        void UpdateProperty_()
        {
            _tbxGroupName.SetValue(_targetGroup.GrouprName);
            _tbxComment.Text = _targetGroup.UserCommentString;
        }

        /// <summary>
        /// UIを更新します。
        /// </summary>
        private void UpdateControls_()
        {
            string name = _tbxGroupName.Text;

            if (name != _targetGroup.GrouprName)
            {
                if (name == String.Empty || _ILEGroupMgr.FindGroupByName(name) != null)
                {
                    _btnOK.Enabled = false;
                    return;
                }

                if (!GroupHelper.CheckGroupNameValid(name))
                {
                    _btnOK.Enabled = false;
                    return;
                }

                _btnOK.Enabled = true;
            }
            else
            {
                _btnOK.Enabled = _tbxComment.Text != _targetGroup.UserCommentString;
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public GroupEditDlg()
        {
            //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region イベントハンドラ
        private void Event_TbxGroupName_ValueChanged(object sender, System.EventArgs e)
        {
            StringTextBox tbx = sender as StringTextBox;

            // 名前が変更されている。
            if( tbx.Text != _targetGroup.GrouprName )
            {
                // 新しい名前が使用されているのか？
                if( _ILEGroupMgr.FindGroupByName( tbx.Text ) != null )
                {
                    // 文字を元に戻す。
                    tbx.Text = _targetGroup.GrouprName;
                }
            }
        }

        private void Event_TbxGroupName_OnTextChanged(object sender, EventArgs e)
        {
            UpdateControls_();
        }

        private void Event_TbxComment_TextChanged(object sender, EventArgs e)
        {
            UpdateControls_();
        }

        private void Event_BtnOK_Click(object sender, System.EventArgs e)
        {
            GroupManipulator     groupManipulator = new GroupManipulator();
            groupManipulator.BindTarget( _targetGroup );

            groupManipulator.Name                 = _tbxGroupName.Text;
            groupManipulator.UserCommentString    = _tbxComment.Text;

            DialogResult = DialogResult.OK;
        }

        private void Event_BtnCancel_Click(object sender, System.EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
        }
        #endregion イベントハンドラ
    }
}
