﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.CurveEditWindow
{
    using ArrowKeySpeed = GraphView.GraphViewMouseState.ArrowKeySpeed;
    /// <summary>
    /// 矢印キーの移動量を設定するダイアログ
    /// </summary>
    public partial class ArrowKeySpeedSettingsDlg : Form
    {
        //------------------------------------------
        #region プロパティ
        public float UpSpeed { get { return _tbxUp.Value; } }
        public float DownSpeed { get { return _tbxDown.Value; } }
        public int LeftSpeed { get { return _tbxLeft.Value; } }
        public int RightSpeed { get { return _tbxRight.Value; } }
        public bool SpeedSettingsEnabled { get { return _chkSpecifiySpeed.Checked; } }


        #endregion プロパティ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ArrowKeySpeedSettingsDlg()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        public void Set( bool bEnabled, float u, float d, int l, int r )
        {
            // 異なる値を設定する場合は、強制的に同期機能を無効にします。
            if( u != d )
            {
                _chkSynchronizeUD.Checked = false;
            }


            if( l != r )
            {
                _chkSynchronizeLR.Checked = false;
            }

            _tbxUp.Value = u;
            _tbxDown.Value = d;
            _tbxLeft.Value = l;
            _tbxRight.Value = r;

            _chkSpecifiySpeed.Checked = bEnabled;

            UpdateOKButtonState_();
        }

        //------------------------------------------
        #region private

        /// <summary>
        ///
        /// </summary>
        void UpdateOKButtonState_()
        {
            _btnOK.Enabled = ArrowKeySpeed.CheckParamatersValid(
                _tbxUp.Value,
                _tbxDown.Value,
                _tbxLeft.Value,
                _tbxRight.Value );
        }

        /// <summary>
        /// 上下の値を更新します。
        /// </summary>
        void UpdateUDValue_( object updater )
        {
            if( _chkSynchronizeUD.Checked )
            {
                if( updater == _tbxDown )
                {
                    _tbxUp.SetValue( _tbxDown.Value );
                }
                else if( updater == _tbxUp )
                {
                    _tbxDown.SetValue( _tbxUp.Value );
                }
            }
            UpdateOKButtonState_();
        }

        /// <summary>
        /// 左右の値を更新します。
        /// </summary>
        void UpdateLRValue_( object updater )
        {
            if( _chkSynchronizeLR.Checked )
            {
                if( updater == _tbxLeft )
                {
                    _tbxRight.SetValue( _tbxLeft.Value );
                }
                else if( updater == _tbxRight )
                {
                    _tbxLeft.SetValue( _tbxRight.Value );
                }
            }
            UpdateOKButtonState_();
        }
        #endregion private

        //------------------------------------------
        #region イベントハンドラ
        /// <summary>
        /// テキストボックス更新ハンドラ(上下)
        /// </summary>
        private void _tbxUp_ValueChanged( object sender, EventArgs e )
        {
            UpdateUDValue_( sender );
        }

        /// <summary>
        /// テキストボックス更新ハンドラ(左右)
        /// </summary>
        private void _tbxLeft_ValueChanged( object sender, EventArgs e )
        {
            UpdateLRValue_( sender );
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_ChkSynchronizeUD_CheckedChanged( object sender, EventArgs e )
        {
            UpdateUDValue_( _tbxUp );
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_ChkSynchronizeLR_CheckedChanged( object sender, EventArgs e )
        {
            UpdateLRValue_( _tbxLeft );
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_ChkSpecifiySpeed_CheckedChanged( object sender, EventArgs e )
        {
            _pnlSpeedSettings.Enabled = _chkSpecifiySpeed.Checked;
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_BtnOK_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_BtnCancel_Click( object sender, EventArgs e )
        {
            DialogResult = DialogResult.Cancel;
        }

        /// <summary>
        ///
        /// </summary>
        private void ArrowKeySpeedSettingsDlg_Leave( object sender, EventArgs e )
        {
            DialogResult = DialogResult.OK;
        }

        #endregion イベントハンドラ

        private void Event_TbxUpDown_TextChanged( object sender, EventArgs e )
        {

        }

        private void Event_TbxLeftRight_TextChanged( object sender, EventArgs e )
        {

        }



    }
}
