﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Forms.Dialogs
{
    /// <summary>
    /// ログを出力するダイアログです。
    /// </summary>
    public partial class LogOutputDlg : LEBaseDlg
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public LogOutputDlg( Form owner )
        {
            InitializeComponent();
            _lblTitle.Text = string.Empty;
            _lblMessage.Text = string.Empty;

            this.Owner = owner;
        }

        /// <summary>
        /// ログを出力します。
        /// </summary>
        public void WriteLog(
            string title,
            string message )
        {
            if( !this.Visible )
            {
                this.Show();
            }

            _lblTitle.Text = title;
            _lblMessage.Text = message;
        }
    }
}
