﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

// INFO: CombinerEditor ソリュージョンにある Communication.Constants と同等の内容を保持する必要があります。
//       Communication.Contracts.IShaderTransferService は通信を行う為に必要な namespace です。

using System.ServiceModel;
using System.Runtime.Serialization;

namespace Communication.Contracts
{
    [DataContract]
    public enum ShaderTransferResult
    {
        [EnumMember]
        Success,
        [EnumMember]
        EmitterNotFound,
    }

    [ServiceContract]
    public interface IShaderTransferServiceV2
    {
        [OperationContract]
        bool Knock();

        [OperationContract]
        ShaderTransferResult Transfer(string filePath, string shaderCode, string workFilePath);

        [OperationContract]
        void OnConnectionClosed();
    }
}
