﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.ServiceModel;

namespace LayoutEditor.src.CombinerEditor
{
    /// <summary>
    /// Class for providing the service transferring shader real time from
    /// EffectCombinerEditor to EffectMaker.
    /// </summary>
    [ServiceBehavior(InstanceContextMode = InstanceContextMode.Single)]
    public class CombinerShaderTransferService : Communication.Contracts.IShaderTransferServiceV2
    {
        private ICombinerCommunicationBridge communicationBridge = null;

        public CombinerShaderTransferService(ICombinerCommunicationBridge communicationBridge)
        {
            this.communicationBridge = communicationBridge;
        }

        /// <summary>
        /// knock method for IShaderTransferServiceV2.
        /// </summary>
        public bool Knock()
        {
            return true;
        }

        /// <summary>
        /// Implemented transfer method for IShaderTransferServiceV2.
        /// </summary>
        /// <param name="filePath">The file path of the shader project.</param>
        /// <param name="shaderCode">The generated shader code.</param>
        /// <returns>The transfer result.</returns>
        public Communication.Contracts.ShaderTransferResult Transfer(string filePath, string shaderCode, string workFilePath)
        {
            if (string.IsNullOrEmpty(filePath) == true)
            {
                return Communication.Contracts.ShaderTransferResult.EmitterNotFound;
            }

            this.communicationBridge.SetReceivedShaderSourceCode(filePath, shaderCode, workFilePath);

            return Communication.Contracts.ShaderTransferResult.Success;
        }

        /// <summary>
        /// Implemented connection close handler for IShaderTransferServiceV2.
        /// </summary>
        public void OnConnectionClosed()
        {
            this.communicationBridge.ClearReceivedShaderSourceCode();
        }
    }
}
