﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace LayoutEditor.src.CombinerEditor
{
    public class CombinerCommunicationManager
    {
        /// <summary>
        /// 初期化したかどうか
        /// </summary>
        private static bool _initialized = false;

        /// <summary>
        /// コンバイナエディタと通信するインスタンス
        /// </summary>
        private static ICombinerCommunicationBridge _communicationBridge = null;

        /// <summary>DLLを集約したフォルダのパスです。</summary>
        private static string coreModulesFolderPath = null;

        /// <summary>The application executable folder path.</summary>
        private static string executableFolderPath = null;

        /// <summary>The application executable file path.</summary>
        private static string executableFilePath = null;

        /// <summary>
        /// DLLを集約したCoreModulesフォルダのパスを取得します。
        /// Visual Studio上から実行した場合はexeと同じパスになります。
        /// </summary>
        public static string CoreModulesPath
        {
            get
            {
                if (string.IsNullOrEmpty(coreModulesFolderPath))
                {
                    coreModulesFolderPath = Directory.Exists(Path.Combine(ExecutableFolderPath, "CoreModules")) ?
                        Path.Combine(ExecutableFolderPath, "CoreModules") :
                        ExecutableFolderPath;
                }

                return coreModulesFolderPath;
            }
        }

        /// <summary>
        /// Get the executable folder path.
        /// </summary>
        public static string ExecutableFolderPath
        {
            get
            {
                if (string.IsNullOrEmpty(executableFolderPath) == true)
                {
                    executableFolderPath = Path.GetDirectoryName(ExecutablePath);
                }

                return executableFolderPath;
            }
        }

        /// <summary>
        /// Get the executable file path.
        /// </summary>
        public static string ExecutablePath
        {
            get
            {
                if (string.IsNullOrEmpty(executableFilePath) == true)
                {
                    var asm = Assembly.GetEntryAssembly();
                    executableFilePath = asm != null ?
                        Path.GetFullPath(asm.Location) :
                        Path.GetFullPath(Assembly.GetExecutingAssembly().Location);
                }

                return executableFilePath;
            }
        }

        /// <summary>
        /// コンバイナエディタと通信するインスタンスのプロパティ
        /// </summary>
        public static ICombinerCommunicationBridge CommunicationBridge
        {
            get
            {
                if (_initialized == false)
                {
                    _initialized = true;

                    _communicationBridge = new LayoutEditor.src.CombinerEditor.CombinerCommunication();
                }

                return _communicationBridge;
            }
        }
    }
}
