﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;

namespace LECore.Structures
{
    using Core;


    /// <summary>
    /// ウインドウ・パーツ番号
    ///
    /// 注意：
    /// 配列アクセスのインデックスとして使用されているため、
    /// 値の変更には注意が必要です。
    /// </summary>
    public enum LEWindowPartsID
    {
        Content = 0,    // コンテンツ

        CornerLT = 1,   // 角：左上
        CornerRT = 2,   // 角：右上
        CornerLB = 3,   // 角：右下
        CornerRB = 4,   // 角：右下

        FrameT = 5,     // 辺：上
        FrameB = 6,     // 辺：下
        FrameL = 7,     // 辺：左
        FrameR = 8,     // 辺：右
    }

    /// <summary>
    /// ウインドウフレーム画像のフリップ・回転処理の種類
    /// </summary>
    public enum LEWindowFrameFlipRotate
    {
        None,
        FlipH,
        FlipV,
        Rotate90,
        Rotate180,
        Rotate270
    }

    /// <summary>
    /// 未設定ならゼロが設定され、その場合、中間ファイルには 要素として現れなくなります。
    /// </summary>
    public struct LEWindowFrameSize
    {
        float _top;
        float _bottom;
        float _left;
        float _right;

        public float Top
        {
            get { return _top; }
            set { _top = value; }
        }

        public float Bottom
        {
            get { return _bottom; }
            set { _bottom = value; }
        }

        public float Left
        {
            get { return _left; }
            set { _left = value; }
        }

        public float Right
        {
            get { return _right; }
            set { _right = value; }
        }

        public bool IsSpecified
        {
            get;
            set;
        }

        public LEWindowFrameSize(float t, float b, float l, float r, bool isSpecified)
        {
            _top = t;
            _bottom = b;
            _left = l;
            _right = r;
            this.IsSpecified = isSpecified;
        }

        public bool IsSame(LEWindowFrameSize another)
        {
            return
                this.Top == another.Top &&
                this.Bottom == another.Bottom &&
                this.Left == another.Left &&
                this.Right == another.Right &&
                this.IsSpecified == another.IsSpecified;
        }


        public static readonly LEWindowFrameSize Empty = new LEWindowFrameSize(0.0f, 0.0f, 0.0f, 0.0f, false);
    }

    /// <summary>
    /// コンテンツ領域拡大量
    /// </summary>
    public struct ILEWindowContentsInflation
    {
        float _top;
        float _bottom;
        float _left;
        float _right;

        #region プロパティ
        public float Top
        {
            get { return _top; }
            set { _top = value; }
        }

        public float Bottom
        {
            get { return _bottom; }
            set { _bottom = value; }
        }

        public float Left
        {
            get { return _left; }
            set { _left = value; }
        }

        public float Right
        {
            get { return _right; }
            set { _right = value; }
        }
        #endregion プロパティ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ILEWindowContentsInflation( float t, float b, float l, float r )
        {
            _top = t;
            _bottom = b;
            _left = l;
            _right = r;
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        public void Set( float t, float b, float l, float r )
        {
            _top = t;
            _bottom = b;
            _left = l;
            _right = r;
        }

        /// <summary>
        /// 同一か判定します。
        /// </summary>
        public bool IsSame( ILEWindowContentsInflation another )
        {
            return
                this._top == another._top &&
                this._bottom == another._bottom &&
                this._left == another._left &&
                this._right == another._right;
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        public void Set( ILEWindowContentsInflation src )
        {
            _top = src.Top;
            _bottom = src.Bottom;
            _left = src.Left;
            _right = src.Right;
        }
    }
}
