﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace LECore.Structures
{
    using LECoreInterface;

    public static class TextureImageHelper
    {
        /// <summary>
        ///
        /// </summary>
        public static FVec2 GetModifiedTranslate(ITextureImage texImg, FVec2 tra)
        {
            float asx = (float)texImg.ActualSize.X;
            float asy = (float)texImg.ActualSize.Y;
            float sx = (float)texImg.Size.X;
            float sy = (float)texImg.Size.Y;
            float ox = asx - sx;
            float oy = asy - sy;
            float ou = (1.0F / asx) * (ox / 2.0F);
            float ov = (1.0F / asy) * (oy / 2.0F);
            float su = (sx / asx);
            float sv = (sy / asy);

            return new FVec2(tra.X * su - ou, tra.Y * sv - ov);
        }

        /// <summary>
        ///
        /// </summary>
        public static FVec2 GetModifiedScale(ITextureImage texImg, FVec2 sca)
        {
            float asx = (float)texImg.ActualSize.X;
            float asy = (float)texImg.ActualSize.Y;
            float sx = (float)texImg.Size.X;
            float sy = (float)texImg.Size.Y;
            float ox = asx - sx;
            float oy = asy - sy;
            float su = (sx / asx);
            float sv = (sy / asy);

            return new FVec2(sca.X * su, sca.Y * sv);
        }

        /// <summary>
        /// 名前が同一か判定します(大文字小文字を区別しません)。
        /// </summary>
        public static bool IsSameName(this ITextureImage image, string name)
        {
            return string.Compare(image.Name, name, true) == 0;
        }

        public static int GetChandelNum(TexImagePixelFmt fmt)
        {
            switch (fmt)
            {
                case TexImagePixelFmt.L4:
                case TexImagePixelFmt.A4:
                case TexImagePixelFmt.L8:
                case TexImagePixelFmt.A8:
                case TexImagePixelFmt.BC4L:
                case TexImagePixelFmt.BC4A:
                    return 1;
                case TexImagePixelFmt.LA4:
                case TexImagePixelFmt.LA8:
                case TexImagePixelFmt.BC5:
                case TexImagePixelFmt.HILO8:
                    return 2;
                case TexImagePixelFmt.ETC1:
                case TexImagePixelFmt.BC1:
                case TexImagePixelFmt.RGB565:
                    return 3;
                case TexImagePixelFmt.RGB8:
                case TexImagePixelFmt.RGB5A1:
                case TexImagePixelFmt.RGBA4:
                case TexImagePixelFmt.RGBA8:
                case TexImagePixelFmt.ETC1A4:
                case TexImagePixelFmt.BC2:
                case TexImagePixelFmt.BC3:
                case TexImagePixelFmt.BC7:
                case TexImagePixelFmt.RGB565_INDIRECT:
                case TexImagePixelFmt.ASTC4x4:
                case TexImagePixelFmt.ASTC5x4:
                case TexImagePixelFmt.ASTC5x5:
                case TexImagePixelFmt.ASTC6x5:
                case TexImagePixelFmt.ASTC6x6:
                case TexImagePixelFmt.ASTC8x5:
                case TexImagePixelFmt.ASTC8x6:
                case TexImagePixelFmt.ASTC8x8:
                case TexImagePixelFmt.ASTC10x5:
                case TexImagePixelFmt.ASTC10x6:
                case TexImagePixelFmt.ASTC10x8:
                case TexImagePixelFmt.ASTC10x10:
                case TexImagePixelFmt.ASTC12x10:
                case TexImagePixelFmt.ASTC12x12:
                default:
                    return 4;
            }
        }
    }

    /// <summary>
    /// 外部モジュール公開インタフェース
    /// </summary>
    public interface ITextureImage
    {
        TexImagePixelFmt PixelFmt { get; set; }
        TextureSourceType SourceType { get; }
        string Name { get; }
        string FilePath { get; }
        IVec3 Size { get; }
        IVec3 ActualSize { get; }
        Bitmap GDIBitmap { get; }
        Bitmap ColorGDIBitmap { get; }
        Bitmap AlphaGDIBitmap { get; }
        bool SrcImageHasAlphaBit { get; }
        bool SrcImageIsGrayScale { get; }
        bool PixelFmtIsFixed { get; }
        bool Valid { get; }
        int TextureDataSize { get; }
        int NativeTextureDataSize { get; }
        int NativeTextureDataSizeNX { get; }
        DateTime UpdateTime { get; }
        bool IsHidingFromList { get; }

        ICaptureTexture ICaptureTexture { get; }

        event EventHandler OnChanged;
    }
}
