﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace LECore.Structures
{
    using Core;
    public interface ISelectedSetChangedEventListener
    {
        void OnSelectedSetChangedEventHandler( IPane[] selSet );
        void OnSelectedSetClickedEventHandler( IPane selSet, PointF posClicked );
    }

    /// <summary>
    /// 選択セットの部分
    /// </summary>
    public enum SelectedSetParts
    {
        Base = 0x00,
        HorizontalL = 0x01,
        HorizontalC = 0x02,
        HorizontalR = 0x04,
        HorizontalOutside = 0x08,
        HorizontalMask = 0x0F,
        VirticalT = 0x10,
        VirticalC = 0x20,
        VirticalB = 0x40,
        VirticalOutside = 0x80,
        VirticalMask = 0x0F,

        ConerLT = HorizontalL | VirticalT,
        ConerRT = HorizontalR | VirticalT,
        ConerLB = HorizontalL | VirticalB,
        ConerRB = HorizontalR | VirticalB,
        SideT = HorizontalC | VirticalT,
        SideB = HorizontalC | VirticalB,
        SideL = HorizontalL | VirticalC,
        SideR = HorizontalR | VirticalC,
        Outside = HorizontalOutside | VirticalOutside
    }



    /// <summary>
    /// 外部公開インタフェース
    /// </summary>
    public interface ISelectedSet :
        ICollidable,
        IDrawable
    {
        IPane[] IPaneArray { get; }
        bool Empty { get; }
        void NotifySelectedSetClickedEvent( IPane pane, PointF point );
    }
}
