﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LECore.Structures.LECoreInterface;

namespace LECore.Structures
{
    using Core;
    using LECore.Structures.Nsrif.Attributes;

    public class ProceduralShapeConstants
    {
        public const int GradationControlPointCount = 4;
    }

    public interface IProceduralShape
    {
        IPane OwnerPane { get; }

        #region 角丸

        /// <summary>
        /// 角丸機能が有効かどうか
        /// </summary>
        bool IsProceduralShapeEnabled { get; }

        /// <summary>
        /// 角丸の形状設定パラメータ。
        /// x ^ Exp + y ^ Exp = 1 の曲線で形状が決定する。
        /// </summary>
        float Exp { get; }

        /// <summary>
        /// 角丸半径
        /// </summary>
        float Radius { get; }

        #endregion

        #region 境界線(内側)

        /// <summary>
        /// 境界線(内側)機能が有効かどうか
        /// </summary>
        bool IsInnerStrokeEnabled { get; }

        /// <summary>
        /// 境界線(内側)の太さ
        /// </summary>
        float InnerStrokeSize { get; }

        /// <summary>
        /// 境界線(内側)のブレンド方法
        /// </summary>
        ProceduralShapeEffectBlendMode InnerStrokeBlendMode { get; }

        /// <summary>
        /// 境界線(内側)の色
        /// </summary>
        RGBAColor InnerStrokeColor { get; }

        #endregion

        #region ドロップシャドウ(内側)

        /// <summary>
        /// ドロップシャドウ(内側)機能が有効かどうか
        /// </summary>
        bool IsInnerShadowEnabled { get; }

        /// <summary>
        /// ドロップシャドウ(内側)
        /// </summary>
        ProceduralShapeEffectBlendMode InnerShadowBlendMode { get; }

        /// <summary>
        /// ドロップシャドウ(内側)の色
        /// </summary>
        RGBAColor InnerShadowColor { get; }

        /// <summary>
        /// ドロップシャドウ(内側)の角度
        /// </summary>
        float InnerShadowAngle { get; }

        /// <summary>
        /// ドロップシャドウ(内側)の距離
        /// </summary>
        float InnerShadowDistance { get; }

        /// <summary>
        /// ドロップシャドウ(内側)のサイズ
        /// </summary>
        float InnerShadowSize { get; }

        /// <summary>
        /// ドロップシャドウ(内側)の影の減衰タイプ
        /// </summary>
        ProceduralShapeShadowType InnerShadowType{ get; }

        #endregion

        #region カラーオーバーレイ

        /// <summary>
        /// カラーオーバーレイが有効かどうか
        /// </summary>
        bool IsColorOverayEnabled { get; }

        /// <summary>
        /// カラーオーバーレイのブレンドモード
        /// </summary>
        ProceduralShapeEffectBlendMode ColorOverlayBlendMode { get; }

        /// <summary>
        /// カラーオーバーレイの色
        /// </summary>
        RGBAColor ColorOverlayColor { get; }

        #endregion

        #region グラデーションオーバーレイ

        /// <summary>
        /// グラデーションオーバーレイが有効かどうか
        /// </summary>
        bool IsGradationOverayEnabled { get; }

        /// <summary>
        /// グラデーションオーバーレイのブレンド方法
        /// </summary>
        ProceduralShapeEffectBlendMode GradationOverlayBlendMode { get; }

        /// <summary>
        ///
        /// </summary>
        int GradationOverlayControlPointCount { get; }

        /// <summary>
        /// 指定したインデックスのグラデーションオーバーレイの色を取得します。
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        RGBAColor GetGradationOverlayColor(int index);

        /// <summary>
        /// 指定したインデックスのグラデーションオーバーレイの色を設定します。
        /// </summary>
        /// <param name="index"></param>
        /// <param name="color"></param>
        void SetGradationOverlayColor(int index, RGBAColor color);

        /// <summary>
        /// 指定したインデックスのグラデーションオーバーレイののコントロールポイントを取得します。
        /// </summary>
        /// <param name="index"></param>
        /// <returns></returns>
        float GetGradationOverlayControlPoint(int index);

        /// <summary>
        /// 指定したインデックスのグラデーションオーバーレイののコントロールポイントを設定します。
        /// </summary>
        /// <param name="index"></param>
        /// <param name="value"></param>
        void SetGradationOverlayControlPoint(int index, float value);

        /// <summary>
        /// グラデーションオーバーレイの角度
        /// </summary>
        float GradationOverlayAngle { get; }

        #endregion

        #region ドロップシャドウ(外側)

        /// <summary>
        /// ドロップシャドウ(外側)が有効かどうか
        /// </summary>
        bool IsOuterShadowEnabled { get; }

        /// <summary>
        /// ドロップシャドウ(外側)のブレンドモード
        /// </summary>
        ProceduralShapeEffectBlendMode OuterShadowBlendMode { get; }

        /// <summary>
        /// ドロップシャドウ(外側)の色
        /// </summary>
        RGBAColor OuterShadowColor { get; }

        /// <summary>
        /// ドロップシャドウ(外側)の角度
        /// </summary>
        float OuterShadowAngle { get; }

        /// <summary>
        /// ドロップシャドウ(外側)の距離
        /// </summary>
        float OuterShadowDistance { get; }

        /// <summary>
        /// ドロップシャドウ(外側)のサイズ
        /// </summary>
        float OuterShadowSize { get; }

        /// <summary>
        /// ドロップシャドウ(外側)の影の減衰タイプ
        /// </summary>
        ProceduralShapeShadowType OuterShadowType { get; }

        #endregion

        #region 角丸アニメーションパラメータへのインターフェイス

        IAnmAttribute IExpAttr { get; }

        IAnmAttribute IRadiusAttr { get; }

        IAnmAttribute IInnerStrokeSizeAttr { get; }

        IAnmAttribute IInnerStrokeColorAttr { get; }

        IAnmAttribute IInnerShadowColorAttr { get; }

        IAnmAttribute IInnerShadowAngleAttr { get; }

        IAnmAttribute IInnerShadowDistanceAttr { get; }

        IAnmAttribute IInnerShadowSizeAttr { get; }

        IAnmAttribute IColorOverlayColorAttr { get; }

        IAnmAttribute[] IGradationOverlayColorAttrArray { get; }

        IAnmAttribute[] IGradationOverlayControlPointAttrArray { get; }

        IAnmAttribute IGradationOverlayAngleAttr { get; }

        IAnmAttribute IOuterShadowColorAttr { get; }

        IAnmAttribute IOuterShadowAngleAttr { get; }

        IAnmAttribute IOuterShadowDistanceAttr { get; }

        IAnmAttribute IOuterShadowSizeAttr { get; }

        #endregion
    }
}
