﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using LECore.Structures.SerializableObject.Lyt;

namespace LECore.Structures
{
    /// <summary>
    /// 外部モジュール公開インタフェース
    /// </summary>
    public interface ILEWindow
        : IVertexColor4Holder, IPaneExParamater, ITexCoordHolder
    {
        WindowKind WindowKind { get; }
        bool UseVtxColorForAllWindow { get; }
        LEWindowFrameSize FrameSize { get; }
        int NumTexture { get;}

        IMaterial GetMaterial( LEWindowPartsID id );
        LEWindowFrameFlipRotate GetMaterialFlipRotateState( LEWindowPartsID id );

        bool GetUseDetailedMaterialFlag( LEWindowPartsID id );
        bool UseLTMaterial { get; }
        bool NotDrawContent { get; }

        bool IsFrameSizeOrFrameSizeCurveSpecified { get; }

        Core.IAnmAttribute FrameSizeIAnmAttr { get; }

        LEWindowPartsID IntToPartsID( int id );
        int PartsIDToInt( LEWindowPartsID id );

        ILEWindowContentsInflation ContentsInflation { get;}
        int NumContentsTexCoord { get;}
        TexCoord4 GetContentsTexCoord4( int texIndex );

        void GetWindowPartsRectangle( int numTexture, LEWindowPartsID partsType, out FVec2 pos, out FVec2 size );
    }
}
