﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Structures.SerializableObject
{
    interface IUserDataFloatList<UserDataElementType>
    {
        UserDataElementType kind { get; set; }
        bool kindSpecified { get; set; }
        string name { get; set; }
        bool overwrite { get; set; }
        string Value { get; set; }
    }

    interface IUserDataIntList<UserDataElementType>
    {
        UserDataElementType kind { get; set; }
        bool kindSpecified { get; set; }
        string name { get; set; }
        bool overwrite { get; set; }
        string Value { get; set; }
    }

    interface IUserDataNone<UserDataElementType>
    {
        UserDataElementType kind { get; set; }
        bool kindSpecified { get; set; }
        string name { get; set; }
        bool overwrite { get; set; }
        string Value { get; set; }
    }

    interface IUserDataString<UserDataElementType>
    {
        UserDataElementType kind { get; set; }
        bool kindSpecified { get; set; }
        string name { get; set; }
        bool overwrite { get; set; }
        string Value { get; set; }
    }

    namespace Lyt
    {
        public partial class UserDataFloatList : IUserDataFloatList<UserDataElementType> { }
        public partial class UserDataIntList : IUserDataIntList<UserDataElementType> { }
        public partial class UserDataNone : IUserDataNone<UserDataElementType> { }
        public partial class UserDataString : IUserDataString<UserDataElementType> { }
    }

    namespace Lan
    {
        public partial class UserDataFloatList : IUserDataFloatList<UserDataElementType> { }
        public partial class UserDataIntList : IUserDataIntList<UserDataElementType> { }
        public partial class UserDataNone : IUserDataNone<UserDataElementType> { }
        public partial class UserDataString : IUserDataString<UserDataElementType> { }
    }
}
