﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Drawing;

namespace LECore.Structures
{
    using System.Collections.Generic;
    using Core;
    using LECoreInterface;
    using System.Linq;

    /// <summary>
    /// 領域ペインです。
    /// </summary>
    internal class Scissor :
        LEDataNode,
        IScissor,
        IPaneExParamater,
        IDrawable,
        IDisposable
    {
        public const string ScissorNodeName = "Scissor";

        // ペイン本体への参照
        readonly Pane   _ownerPane = null;

        void NotifyChangeToScene_()
        {
            NotifyModifyEvent(this, (int)SceneModifyEventArgs.Kind.PaneModify);
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Scissor( Pane ownerPane )
            :base(ownerPane, ScissorNodeName)
        {
            Debug.Assert( ownerPane != null );
            _ownerPane = ownerPane;
            _ownerPane.BindPaneExData( this );
        }

        /// <summary>
        /// リソースを開放します。
        /// </summary>
        public void Dispose()
        {
        }

        #region Scissor

        #endregion

        #region IPaneExParamater
        /// <summary>
        /// 自身を持っているペインの参照です。
        /// </summary>
        public IPane OwnerPane
        {
            get{ return _ownerPane;}
        }

        /// <summary>
        /// 自身を持っているペインの参照です。
        /// </summary>
        public void          UpdateMatarialName   ()
        {
            // Do Nothing
        }

        /// <summary>
        /// シーン登録時の初期化処理
        /// </summary>
        public void OnJoinSceneInitialize()
        {
            // 何もしません。
        }

        /// <summary>
        /// 編集対象に設定される直前の初期化処理
        /// </summary>
        public void FirstTimeInitialize()
        {
            // 何もしません。
        }

        /// <summary>
        /// UV座標を列挙します。
        /// </summary>
        public IEnumerable<TexCoord4> TexCoords
        {
            get { yield break; }
        }

        /// <summary>
        /// 警告文字列を取得します。UIの各所で表示します。
        /// </summary>
        public string WarningMsg
        {
            get { return string.Empty; }
        }

        /// <summary>
        /// 境界を書くかどうか
        /// </summary>
        public bool PaneBoundDrawEnabled
        {
            get { return true; }
        }
        #endregion IPaneExParamater

        #region IDrawable
        public void Draw( IRenderer renderer, DrawableOption option )
        {
            System.Drawing.Font sysFont = LayoutEditorCore.GuiFont;
            renderer.DbgDrawString("Scissor_Pane", sysFont, 0, 0 );

            Color  oldColor = renderer.Color;

            renderer.Color = option.SystemOpeMagenta;
            renderer.FillRectangle(0, 0, 0, OwnerPane.RenderingWidth, OwnerPane.RenderingHeight);
            renderer.Color = oldColor;
        }
        #endregion IDrawable
    }
}
