﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Save_Load
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lyt;

    public partial class RlytConverter
    {
        #region File => App
        void Convert_Pane_DropShadow_(AppData.DropShadow dstDropShadow, FileFmt.DropShadow srcDropShadow)
        {
            if (srcDropShadow == null)
            {
                dstDropShadow.IsKnockoutEnabled = true;
                dstDropShadow.IsOnlyEffectEnabled = false;
                dstDropShadow.IsStaticRenderingEnabled = false;
                dstDropShadow.IsStrokeEnabled = false;
                dstDropShadow.IsOuterGlowEnabled = false;
                dstDropShadow.IsDropShadowEnabled = false;
                return;
            }

            dstDropShadow.IsKnockoutEnabled = srcDropShadow.knockout;
            dstDropShadow.IsOnlyEffectEnabled = srcDropShadow.onlyEffect;
            dstDropShadow.IsStaticRenderingEnabled = srcDropShadow.staticRendering;
            dstDropShadow.IsStrokeEnabled = srcDropShadow.strokeEnabled;
            dstDropShadow.strokeSize = srcDropShadow.strokeSize;
            dstDropShadow.strokeBlendMode = (AppData.LECoreInterface.DropShadowBlendMode)srcDropShadow.strokeBlendMode;
            dstDropShadow.strokeColor = Convert_RGBAColor_(srcDropShadow.strokeColor);
            dstDropShadow.IsOuterGlowEnabled = srcDropShadow.outerGlowEnabled;
            dstDropShadow.outerGlowBlendMode = (AppData.LECoreInterface.DropShadowBlendMode)srcDropShadow.outerGlowBlendMode;
            dstDropShadow.outerGlowColor = Convert_RGBAColor_(srcDropShadow.outerGlowColor);
            dstDropShadow.outerGlowSpread = srcDropShadow.outerGlowSpread;
            dstDropShadow.outerGlowSize = srcDropShadow.outerGlowSize;
            dstDropShadow.IsDropShadowEnabled = srcDropShadow.dropShadowEnabled;
            dstDropShadow.dropShadowBlendMode = (AppData.LECoreInterface.DropShadowBlendMode)srcDropShadow.dropShadowBlendMode;
            dstDropShadow.dropShadowColor = Convert_RGBAColor_(srcDropShadow.dropShadowColor);
            dstDropShadow.dropShadowAngle = srcDropShadow.dropShadowAngle;
            dstDropShadow.dropShadowDistance = srcDropShadow.dropShadowDistance;
            dstDropShadow.dropShadowSpread = srcDropShadow.dropShadowSpread;
            dstDropShadow.dropShadowSize = srcDropShadow.dropShadowSize;
        }
        #endregion

        #region App => File

        FileFmt.DropShadow Convert_ToFile_DropShadow_(AppData.IDropShadow srcDropShadow)
        {
            if (!srcDropShadow.IsDropShadowEtcEnabled)
            {
                return null;
            }

            FileFmt.DropShadow dstDropShadow = new FileFmt.DropShadow();
            dstDropShadow.knockout = srcDropShadow.IsKnockoutEnabled;
            dstDropShadow.onlyEffect = srcDropShadow.IsOnlyEffectEnabled;
            dstDropShadow.staticRendering = srcDropShadow.IsStaticRenderingEnabled;
            dstDropShadow.strokeEnabled = srcDropShadow.IsStrokeEnabled;
            dstDropShadow.strokeSize = srcDropShadow.strokeSize;
            dstDropShadow.strokeBlendMode = (FileFmt.DropShadowBlendMode)srcDropShadow.strokeBlendMode;
            dstDropShadow.strokeColor = Convert_Color4_(srcDropShadow.strokeColor);
            dstDropShadow.outerGlowEnabled = srcDropShadow.IsOuterGlowEnabled;
            dstDropShadow.outerGlowBlendMode = (FileFmt.DropShadowBlendMode)srcDropShadow.outerGlowBlendMode;
            dstDropShadow.outerGlowColor = Convert_Color4_(srcDropShadow.outerGlowColor);
            dstDropShadow.outerGlowSpread = srcDropShadow.outerGlowSpread;
            dstDropShadow.outerGlowSize = srcDropShadow.outerGlowSize;
            dstDropShadow.dropShadowEnabled = srcDropShadow.IsDropShadowEnabled;
            dstDropShadow.dropShadowBlendMode = (FileFmt.DropShadowBlendMode)srcDropShadow.dropShadowBlendMode;
            dstDropShadow.dropShadowColor = Convert_Color4_(srcDropShadow.dropShadowColor);
            dstDropShadow.dropShadowAngle = srcDropShadow.dropShadowAngle;
            dstDropShadow.dropShadowDistance = srcDropShadow.dropShadowDistance;
            dstDropShadow.dropShadowSpread = srcDropShadow.dropShadowSpread;
            dstDropShadow.dropShadowSize = srcDropShadow.dropShadowSize;

            // maxSize はテクスチャのサイズを決定することに使用する。
            // アニメーションカーブから計算することが望ましいが、
            // ひとまず固定の値を返しておく。
            dstDropShadow.maxSize = 32;

            FileFmt.TexMap dstCaptureTexMap = new FileFmt.TexMap();
            dstCaptureTexMap.wrap_s = FileFmt.TexWrapMode.Clamp;
            dstCaptureTexMap.wrap_t = FileFmt.TexWrapMode.Clamp;
            dstCaptureTexMap.imageName = srcDropShadow.OwnerPane.PaneName + CaptureTexture.GetNameSuffix(CaptureTextureUsage.DropShadow);
            dstCaptureTexMap.minFilter = FileFmt.TexFilter.Linear;
            dstCaptureTexMap.magFilter = FileFmt.TexFilter.Linear;
            dstCaptureTexMap.textureResourceType = FileFmt.TextureResourceType.LocalCaptured;
            dstDropShadow.captureTexMap = dstCaptureTexMap;

            return dstDropShadow;
        }

        #endregion

        internal AppData.DropShadow Convert_Pane_DropShadowSelf(AppData.Pane dstPane, FileFmt.DropShadow srcDropShadow)
        {
            AppData.DropShadow dropShadow = new Structures.DropShadow(dstPane);
            Convert_Pane_DropShadow_(dropShadow, srcDropShadow);
            return dropShadow;
        }

        internal FileFmt.DropShadow Convert_Item_DropShadowSelf(AppData.IDropShadow srcDropShadow)
        {
            return Convert_ToFile_DropShadow_(srcDropShadow);
        }
    }
}
