﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Core.Command;
    /// <summary>
    /// BaseManipulator の概要の説明です。
    /// </summary>
    public class BaseManipulator
    {
        /// <summary>
        /// コマンドファクトリクラスを取得します。
        /// 現在の操作対象サブシーンから、ファクトリを取得しています。
        ///
        /// FIX_ME !
        /// Manipulatorの捜査対象がサブシーンに属していることを確認したい。
        /// </summary>
        internal static CommandFactory	_CommandFactory
        {
            get
            {
                if (Scene.CurrentSubScene == null) { return null; }
                return Scene.CurrentSubScene.CommandFactory;
            }
        }

       public BaseManipulator()
        {

        }
    }
}
