﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace System::Collections;



#include "ResFont.h"

namespace NW4R
{
namespace Font
{
    //
    // グリフを表すクラス
    // UnManaged::Glyphのマネージド・ラッパー
    //
    public ref struct NW4RGlyph
    {
    public:

       void*      pTexture;      // グリフが参照するテクスチャデータへのポインタ
       u32         sheetNo;       // グリフが参照するテクスチャシートの番号(拡張)


       u16         height;        // 文字のグリフ高

       // CharWidths  widths;
       s16         left;          // 文字の左スペースの幅
       u16         glyphWidth;    // 文字のグリフ幅
       u16         charWidth;     // 文字の幅 = 左スペース幅 + グリフ幅 + 右スペース幅
       u16         rawWidth;      // テクスチャキャッシュ上の文字幅
       u16         rawHeight;     // テクスチャキャッシュ上の文字の高さ

       // テクスチャフォーマット情報は反映されません。
       // 必ず、RGBA8フォーマットとなります。(内部でデータ変換されます。)
       // GXTexFmt    texFormat;

       u16         texWidth;      // グリフが参照するテクスチャの幅
       u16         texHeight;     // グリフが参照するテクスチャの高さ
       u16         cellX;         // グリフが参照するテクスチャ内でのX座標位置(UV値算出に利用)
       u16         cellY; 	      // グリフが参照するテクスチャ内でのY座標位置(UV値算出に利用)

       bool isBitmapFont; // 追加 : .NET モジュールで sRGB の判定に使用します。
       u16 sheetFormat;	  // 追加 : .NET モジュールで sRGB の判定に使用します。

       //
       // コンストラクタ
       //
        NW4RGlyph( UnManaged::Glyph* src )
        {
           pTexture   = const_cast<void*>(src->pTexture);
           sheetNo    = src->sheetNo;
           height     = src->height;
           left       = src->widths.left;
           glyphWidth = src->widths.glyphWidth;
           charWidth  = src->widths.charWidth;
           rawWidth   = src->widths.rawWidth;
           rawHeight  = src->rawHeight;

           texWidth   = src->texWidth;
           texHeight  = src->texHeight;
           cellX      = src->cellX;
           cellY      = src->cellY;

           isBitmapFont = src->isBitmapFont;
           sheetFormat = src->sheetFormat;
        }
    };
}
}
