﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef BYTE_ORDER_UTIL_H_
#define BYTE_ORDER_UTIL_H_

#include <dolphin/types.h>


namespace NW4R
{
namespace Font
{


template<typename VAL>
static VAL Swap4Byte( VAL in )
{
    u32              out;
    const u8*        pIn     = (const u8*)&in;
    u8*              pOut    = (u8*)&out;

    pOut[0] = pIn[3];
    pOut[1] = pIn[2];
    pOut[2] = pIn[1];
    pOut[3] = pIn[0];

    return (VAL)out;
}

template<typename VAL>
static VAL Swap2Byte( VAL in )
{
    u16              out;
    const u8*        pIn     = (const u8*)&in;
    u8*              pOut    = (u8*)&out;

    pOut[0] = pIn[1];
    pOut[1] = pIn[0];

    return (VAL)out;
}


}
}

#endif // BYTE_ORDER_UTIL_H_
