﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.IO;
    using System.Reflection;

    public partial class GlCm
    {
#if DEBUG
        public const string VersionDebug = " DEBUG build";
#else
        public const string VersionDebug   = "";
#endif

        /// <summary>
        /// プロダクト情報を取得します。
        /// </summary>
        /// <returns>プロダクト情報を返します。</returns>
        public static string GetProductInfo()
        {
            var productInfo = "Font Converter";

            var mainAssembly = Assembly.GetEntryAssembly();
            var productArray = mainAssembly.GetCustomAttributes(typeof(AssemblyProductAttribute), false);
            if (productArray != null && productArray.Length > 0)
            {
                productInfo = string.Empty;

                var exeFileName = GetExecFileName();
                var prefixIdx = exeFileName.IndexOf('_');
                if (prefixIdx != -1)
                {
                    productInfo += exeFileName.Substring(0, prefixIdx).ToUpperInvariant() + " ";
                }

                productInfo += ((AssemblyProductAttribute)productArray[0]).Product;
            }
            return productInfo;
        }

        /// <summary>
        /// 実行ファイルのファイル名(拡張子無し)を取得します。
        /// </summary>
        /// <returns>実行ファイルのファイル名(拡張子無し)を返します。</returns>
        public static string GetExecFileName()
        {
            var assembly = Assembly.GetEntryAssembly();
            return Path.GetFileNameWithoutExtension(assembly.Location);
        }

        /// <summary>
        /// バージョン文字列を取得します。
        /// </summary>
        /// <returns>バージョン文字列を返します。</returns>
        public static string GetVersionString(string platformName)
        {
            return GetFontConverterVersion()
                + (!string.IsNullOrEmpty(platformName) ? " [" + platformName + "]" : string.Empty)
                + VersionDebug;
        }

        /// <summary>
        /// フォントコンバータのバージョンを取得します。
        /// </summary>
        /// <returns>フォントコンバータのバージョンを返します。</returns>
        public static string GetFontConverterVersion()
        {
            // エントリーアセンブリのバージョンを表示します。
            var mainAssembly = Assembly.GetEntryAssembly();
            var appVersion = mainAssembly.GetName().Version;
            var verFormat = appVersion.Revision == 0 ? "{0}.{1}.{2}" : "{0}.{1}.{2}.{3}";

            return string.Format(verFormat, appVersion.Major, appVersion.Minor, appVersion.Build, appVersion.Revision);
        }
    }
}
