﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System.Diagnostics.CodeAnalysis;
    using System.Runtime.InteropServices;

    public class LibFormat
    {
        public const string ExtensionFont = "b" + ConverterEnvironment.PlatformCharSmall + "fnt";
        public const string ExtensionArchiveFont = "b" + ConverterEnvironment.PlatformCharSmall + "fna";
        public const string ExtensionScalableFont = "b" + ConverterEnvironment.PlatformCharSmall + "ttf";
    }

    [StructLayout(LayoutKind.Sequential)]
    [SuppressMessage("Microsoft.StyleCop.CSharp.MaintainabilityRules", "SA1401:FieldsMustBePrivate", Justification = "Binay Image")]
    public class LibFormatFontGlyph
    {
        /// <summary>
        /// グリフイメージ1ラインのピクセル数
        /// </summary>
        public byte CellWidth;

        /// <summary>
        /// グリフイメージのライン数
        /// </summary>
        public byte CellHeight;

        /// <summary>
        /// 1グリフあたりのグリフイメージデータサイズ
        /// </summary>
        public ushort CellSize;

        /// <summary>
        /// (*)グリフイメージ上端からベースラインまでの距離
        /// </summary>
        public short BaselinePos;

        /// <summary>
        /// (*)最大グリフ幅
        /// </summary>
        public byte MaxCharWidth;

        /// <summary>
        /// グリフイメージ1ピクセルあたりのbit数
        /// </summary>
        public byte Bpp;

        /// <summary>
        /// 予約
        /// </summary>
        private byte reserved;

        //// byte  glyphTable[];       // グリフイメージの配列
    }
}
