﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Diagnostics.CodeAnalysis;
    using System.Runtime.InteropServices;

    /// <summary>
    /// 4文字のASCII文字で構成されるシグネチャを表す構造体です。
    /// シグネチャはエンディアンに依存しません。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    [SuppressMessage("Microsoft.StyleCop.CSharp.MaintainabilityRules", "SA1401:FieldsMustBePrivate", Justification = "Binay Image")]
    public struct Signature32 : IEquatable<Signature32>
    {
        public byte B0;
        public byte B1;
        public byte B2;
        public byte B3;

        public Signature32(string signature)
        {
            if (signature == null)
            {
                throw new ArgumentNullException("signature");
            }

            if (signature.Length != 4)
            {
                throw new ArgumentException("signature length must be 4.");
            }

            this.B0 = (byte)signature[0];
            this.B1 = (byte)signature[1];
            this.B2 = (byte)signature[2];
            this.B3 = (byte)signature[3];
        }

        public Signature32(char c0, char c1, char c2, char c3)
        {
            this.B0 = (byte)c0;
            this.B1 = (byte)c1;
            this.B2 = (byte)c2;
            this.B3 = (byte)c3;
        }

        public static bool operator ==(Signature32 left, Signature32 right)
        {
            return left.Equals(right);
        }

        public static bool operator !=(Signature32 left, Signature32 right)
        {
            return !left.Equals(right);
        }

        public override bool Equals(object obj)
        {
            return obj is Signature32 && this.Equals((Signature32)obj);
        }

        public bool Equals(Signature32 other)
        {
            return this.B0 == other.B0
                && this.B1 == other.B1
                && this.B2 == other.B2
                && this.B3 == other.B3;
        }

        public override int GetHashCode()
        {
            return (this.B0 << 24) | (this.B1 << 16) | (this.B2 << 8) | this.B3;
        }
    }
}
