﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System.Collections.Generic;

    public class GlyphList
    {
        private readonly GlyphArray List = new GlyphArray();
        private readonly GlyphMap Map = new GlyphMap();

        public Glyph GetByCode(uint ccode)
        {
            Glyph value;
            var result = this.Map.TryGetValue(ccode, out value);

            return result ? value : null;
        }

        public void AddGlyph(Glyph glyph, uint ccode)
        {
            Glyph value;
            var isFound = this.Map.TryGetValue(ccode, out value);

            //---- 既にグリフ登録済みの文字コードか？
            if (isFound)
            {
                if (!glyph.Equals(value))
                {
                    ProgressControl.Warning(Strings.IDS_WARN_MULTIPLE_GLYPHS, ccode, ccode);
                }

                return;
            }

            glyph.SetIndex((ushort)this.List.Count);
            glyph.SetCode(ccode);

            this.Map[ccode] = glyph;
            this.List.Add(glyph);
        }

        public void Reserve(int num)
        {
            this.List.Capacity = num;
        }

        public int GetNum()
        {
            return this.List.Count;
        }

        public void SortByCode()
        {
            CodeSortPred pred = new CodeSortPred();

            this.List.Sort(pred);

            ushort i = 0;

            foreach (var g in this.List)
            {
                g.SetIndex(i);
                ++i;
            }
        }

        public void SortByIndex()
        {
            IndexSortPred pred = new IndexSortPred();

            this.List.Sort(pred);
        }

        public IEnumerable<Glyph> GetEnum()
        {
            return this.List;
        }

        public Glyph GetFirstItem()
        {
            return this.List[0];
        }

        private class GlyphArray : List<Glyph>
        {
        }

        private class GlyphMap : Dictionary<uint, Glyph>
        {
        }

        private class CodeSortPred : IComparer<Glyph>
        {
            public int Compare(Glyph left, Glyph right)
            {
                return (int)left.GetCode() - (int)right.GetCode();
            }
        }

        private class IndexSortPred : IComparer<Glyph>
        {
            public int Compare(Glyph left, Glyph right)
            {
                return left.GetIndex() - right.GetIndex();
            }
        }
    }
}
