﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using NintendoWare.Font.Win32;

    public abstract class FontReader : FontIO
    {
        public abstract void ReadFontData(FontData fontData, CharFilter filter);

        public KerningPair[] FilterKerningPairs(KerningPair[] pairs, CharFilter filter)
        {
            if (pairs != null && pairs.Length > 0)
            {
                // フィルタして残るペアの数を調べる
                int remainedNum = 0;
                foreach (KerningPair pair in pairs)
                {
                    if (pair.KernAmount != 0 && (!filter.IsFiltered(pair.First)) && (!filter.IsFiltered(pair.Second)))
                    {
                        remainedNum += 1;
                    }
                }
                KerningPair[] filteredPairs = new KerningPair[remainedNum];
                int count = 0;
                foreach (KerningPair pair in pairs)
                {
                    if (pair.KernAmount != 0 && (!filter.IsFiltered(pair.First)) && (!filter.IsFiltered(pair.Second)))
                    {
                        filteredPairs[count] = pair;
                        count += 1;
                    }
                }
                return filteredPairs;
            }
            else
            {
                return pairs;
            }
        }
    }
}
