﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.IO;
    using System.Security;

    /// <summary>
    /// バイナリファイルを扱うクラスです。
    /// </summary>
    public class BinaryFile : FileStream
    {
        //-----------------------------------------------------------------
        // フィールド
        //-----------------------------------------------------------------
        protected readonly string FilePath;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="fname">対象となるバイナリファイルへのパス名です。</param>
        /// <param name="create"></param>
        /// <param name="access"></param>
        /// <param name="share"></param>
        protected BinaryFile(string fname, FileMode create, FileAccess access, FileShare share)
            : base(fname, create, access, share)
        {
            this.FilePath = fname;
        }

        /// <summary>
        ///
        /// </summary>
        public override long Position
        {
            get
            {
                try
                {
                    return base.Position;
                }
                catch (IOException)
                {
                    throw GlCm.ErrMsg(ErrorType.Fio, Strings.IDS_ERR_CANT_TELL, this.FilePath);
                }
            }

            set
            {
                try
                {
                    base.Position = value;
                }
                catch (IOException)
                {
                    throw GlCm.ErrMsg(ErrorType.Fio, Strings.IDS_ERR_CANT_TELL, this.FilePath);
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public static BinaryFile Open(string fname, FileMode create, FileAccess access)
        {
            try
            {
                return new BinaryFile(fname, create, access, FileShare.Delete | FileShare.Read | FileShare.Write);
            }
            catch (UnauthorizedAccessException)
            {
            }
            catch (SecurityException)
            {
            }
            catch (IOException)
            {
            }

            throw GlCm.ErrMsg(ErrorType.Fio, Strings.IDS_ERR_CANT_OPEN, fname);
        }

        /// <summary>
        ///
        /// </summary>
        public string GetFileName()
        {
            return this.FilePath;
        }

        /// <summary>
        ///
        /// </summary>
        public override int Read(byte[] buf, int offset, int len)
        {
            try
            {
                return base.Read(buf, offset, len);
            }
            catch (IOException)
            {
            }

            throw GlCm.ErrMsg(ErrorType.Fio, Strings.IDS_ERR_CANT_READ, this.FilePath);
        }

        /// <summary>
        ///
        /// </summary>
        public override void Write(byte[] buf, int offset, int len)
        {
            try
            {
                if (len > 0)
                {
                    base.Write(buf, offset, len);
                }
            }
            catch (IOException)
            {
                throw GlCm.ErrMsg(ErrorType.Fio, Strings.IDS_ERR_CANT_WRITE, this.FilePath);
            }
        }

        /// <summary>
        ///
        /// </summary>
        public override long Seek(long offset, SeekOrigin origin)
        {
            try
            {
                return base.Seek(offset, origin);
            }
            catch (IOException)
            {
                throw GlCm.ErrMsg(ErrorType.Fio, Strings.IDS_ERR_SEEK_FROM_BEGIN, this.FilePath);
            }
        }
    }
}
