﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    /// <summary>
    /// ImageFileFormatのViewModelです。
    /// </summary>
    public class ImageFileFormatViewModel
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="title">表示文字列です。</param>
        /// <param name="format">ImageFileFormatの値です。</param>
        /// <param name="fileExtension">ファイル拡張子です。</param>
        public ImageFileFormatViewModel(string title, ImageFileFormat format, string fileExtension)
        {
            this.Title = title;
            this.Format = format;
            this.FileExtension = fileExtension;
        }

        /// <summary>
        /// 表示文字列を取得または設定します。
        /// </summary>
        public string Title { get; private set; }

        /// <summary>
        /// ImageFileFormatの値を取得または設定します。
        /// </summary>
        public ImageFileFormat Format { get; private set; }

        /// <summary>
        /// ファイル拡張子を取得または設定します。
        /// </summary>
        public string FileExtension { get; private set; }
    }
}
