﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System.Collections.Generic;
    using System.Collections.ObjectModel;

    /// <summary>
    /// ObservableCollectionを継承した文字列コレクションです。
    /// </summary>
    public class StringObservableCollection : ObservableCollection<string>
    {
        private const int MaxHistory = 10;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public StringObservableCollection()
            : base()
        {
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="list">文字列リストです。</param>
        public StringObservableCollection(List<string> list)
            : base(list)
        {
        }

        // in(path) -> pathHistory
        // pathHistory の先頭に path を追加
        // path が既に存在する場合は先頭に移動

        /// <summary>
        /// 文字列を先頭に追加します。
        /// コレクション内の個数が上限を超える場合は
        /// 超えた分がコレクションの末尾から取り除かれます。
        /// 既に同じ文字列が登録されていた場合は、
        /// 先頭に移動します。
        /// </summary>
        /// <param name="str">追加する文字列。</param>
        public void InsertHistoryFront(string str)
        {
            if (str == string.Empty)
            {
                return;
            }

            var execStrIdx = this.IndexOf(str);
            if (execStrIdx == -1)
            {
                while (this.Count >= MaxHistory)
                {
                    this.RemoveAt(this.Count - 1);
                }

                this.Insert(0, str);
            }
            else if (execStrIdx != 0)
            {
                this.Move(execStrIdx, 0);
            }
        }
    }
}
