﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#pragma once

#include "Config.h"
#include <nn/vfx/vfx_System.h>


namespace detail {

/**
 * @brief テストカスタムパラメータクラス
 *
 * @details テストカスタムパラメータ用クラスです。
 */
class EmulateTestCustomBehavior
{
public:
    enum
    {
        MaxFrames = 60
    };

    /**
     * @brief テストカスタム動作ユーザデータビット
     *
     */
    enum TestCustomBehaviorUserDataBit
    {
        TestCustomBehavior_UserDataBit_0  = 1<<0,        // Camera Y Z位置 注視点_Yの設定(固定)
        TestCustomBehavior_UserDataBit_1  = 1<<1,        // カメラ位置アニメ
        TestCustomBehavior_UserDataBit_2  = 1<<2,        // カメラタイプを「パースペクティブ」から「オルソ」に変更
        TestCustomBehavior_UserDataBit_3  = 1<<3,
        TestCustomBehavior_UserDataBit_4  = 1<<4,
        TestCustomBehavior_UserDataBit_5  = 1<<5,
        TestCustomBehavior_UserDataBit_6  = 1<<6,
        TestCustomBehavior_UserDataBit_7  = 1<<7,
        TestCustomBehavior_UserDataBit_8  = 1<<8,
        TestCustomBehavior_UserDataBit_9  = 1<<9,
        TestCustomBehavior_UserDataBit_10 = 1<<10,
        TestCustomBehavior_UserDataBit_11 = 1<<11,
        TestCustomBehavior_UserDataBit_12 = 1<<12,
        TestCustomBehavior_UserDataBit_13 = 1<<13,
        TestCustomBehavior_UserDataBit_14 = 1<<14,
        TestCustomBehavior_UserDataBit_15 = 1<<15,
    };

    /**
     * @brief コンストラクタ
     *
     */
    EmulateTestCustomBehavior() NN_NOEXCEPT {};

    /**
     * @brief デストラクタ
     *
     */
    ~EmulateTestCustomBehavior() NN_NOEXCEPT {};

   /**
     * @brief カメラの更新
     *
     * @param[in] pSystem              エフェクトシステムハンドル
     * @param[in] width                スクリーン幅
     * @param[in] height               スクリーン高さ
     * @param[in] frameTime            ビューアの時間（フレーム数）
     */
    void Update( nn::vfx::System* pSystem, int width, int height, float frameTime ) NN_NOEXCEPT;

   /**
     * @brief カメラポジションを取得
     *
     * @return    現在のカメラポジションを返します。
     */
    nn::util::Vector3fType* GetCurrentCameraPos() NN_NOEXCEPT { return &m_CameraPosition; }

   /**
     * @brief ビューのマトリックスを取得
     *
     * @return    現在のビューのマトリックスを返します。
     */
    nn::util::Matrix4x3fType* GetView() NN_NOEXCEPT { return &m_View; }

   /**
     * @brief プロジェクションのマトリックスを取得
     *
     * @return    現在のプロジェクションのマトリックスを返します。
     */
    nn::util::Matrix4x4fType* GetProjMatrix() NN_NOEXCEPT { return &m_ProjctionMatrix; }

private:
    nn::util::Vector3fType              m_CameraPosition;            // カメラ位置
    nn::util::Matrix4x3fType            m_View;                      // モデルビュー
    nn::util::Matrix4x4fType            m_ProjctionMatrix;          // プロジェクション

};

}
