﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <Config.h>
#if defined( NN_BUILD_CONFIG_OS_WIN )
#include <nn/nn_Windows.h>
#include <GL/glew.h>
#include <stdio.h>
#endif

#include <nn/nn_Common.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/gfx.h>
#if defined( NN_BUILD_CONFIG_OS_WIN )
#include <detail/util_PngIO.h>
#endif

class FrameCapture
{
public:
    FrameCapture( ) NN_NOEXCEPT :  m_pHeap( nullptr )
                      ,m_Width( 0 )
                      ,m_Height( 0 )
                      ,m_CaptureBuffer( nullptr )
                      ,m_CaptureIndex( 0 )
                      ,m_CaptureCommandPushed( false )
    {}

    ~FrameCapture() NN_NOEXCEPT {}


    // ヒープを設定する
    void SetHeap( nn::lmem::HeapHandle* heapHandle ) NN_NOEXCEPT
    {
        m_pHeap = heapHandle;
    }

    // キャプチャコマンドを発行する
    void PushCaptureCommand( nn::gfx::CommandBuffer* pCommandBuffer, nn::gfx::Buffer* dstBuffer, nn::gfx::Texture* srcTexture, int width, int height ) NN_NOEXCEPT;

    // 指定ディレクトリに 連番付きファイル名でキャプチャ画像を保存する
    void CaptureFrameWithDirectoryPath( const char* directoryPath, int interval ) NN_NOEXCEPT;

    // 指定ファイル名でキャプチャ画像を保存する
    void CaptureFrameWithFilePath( const char* filePath ) NN_NOEXCEPT;

    // 指定フォルダ内 キャプチャ画像を削除する
    void ClearScreenCapDirectory( const char* directoryPath ) NN_NOEXCEPT;

    // 連番付きキャプチャ画像を保存する為のフォルダを生成する
    void CreateScreenCapDirectory( const char* directoryPath ) NN_NOEXCEPT;

    // キャプチャコマンドを積んだか
    bool IsCaptureCommandPushed() const NN_NOEXCEPT
    {
        return m_CaptureCommandPushed;
    }

    // 連番付きキャプチャ画像のインデックスをクリアする
    void ClearIndex() NN_NOEXCEPT
    {
        m_CaptureIndex = 0;
    }

private:
    //------------------------------------------------------------------------------
    //      キャプチャ処理
    //------------------------------------------------------------------------------
    void SaveCurrentBufferAsPngFile( const char* fileName ) NN_NOEXCEPT;

private:
    nn::lmem::HeapHandle*                m_pHeap;
    int                                  m_Width;
    int                                  m_Height;
    nn::gfx::Buffer*                     m_CaptureBuffer;
    int                                  m_CaptureIndex;
    bool                                 m_CaptureCommandPushed;
};
