﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.Collections.Generic;
using System.Linq;

namespace EffectMaker.UIControls.EffectBrowser
{
    /// <summary>
    /// The effect browser panel.
    /// </summary>
    public partial class EffectBrowserPanel
    {
        /// <summary>
        /// The max directory path history.
        /// </summary>
        private const int MaxDirectoryPathHistory = 10;

        /// <summary>
        /// The directory path history.
        /// </summary>
        private List<string> directoryPathHistory = new List<string>();

        /// <summary>
        /// The push directory path history.
        /// </summary>
        /// <param name="dirPath">
        /// The dir path.
        /// </param>
        public void PushDirectoryPathHistory(string dirPath)
        {
            System.Diagnostics.Debug.Assert(string.IsNullOrEmpty(dirPath) == false, "string.IsNullOrEmpty(dirPath) == false");

            this.directoryPathHistory.Remove(dirPath);
            this.directoryPathHistory.Insert(0, dirPath);

            while (this.directoryPathHistory.Count() > MaxDirectoryPathHistory)
            {
                this.directoryPathHistory.RemoveAt(this.directoryPathHistory.Count() - 1);
            }
        }
    }
}
