﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.FileListView.Base
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Data;

    /// <summary>
    /// The eb file list view.
    /// </summary>
    public partial class EBFileListView
    {
        #region Fields

        /// <summary>
        /// The current sort column.
        /// </summary>
        private EBFileListViewColumn currentSortColumn;

        #endregion

        #region Methods

        /// <summary>
        /// The on column click.
        /// </summary>
        /// <param name="e">
        /// イベント引数
        /// </param>
        protected override void OnColumnClick(ColumnClickEventArgs e)
        {
            base.OnColumnClick(e);

            this.SelectedIndices.Clear();

            this.ToggleSort(e.Column);

            this.RunUpdate(UpdateStateKind.Resort);
        }

        /// <summary>
        /// The set column header sort icon.
        /// </summary>
        private void SetColumnHeaderSortIcon()
        {
            var visibleColumns = this.ColumnInfos.Values.Where(x => x.Visible).OrderBy(x => x.Index).ToArray();

            for (var i = 0; i != visibleColumns.Count(); ++i)
            {
                this.SetColumnHeaderSortIcon(
                    i,
                    (visibleColumns[i] == this.currentSortColumn) ? visibleColumns[i].SortOrder : SortOrder.None);
            }
        }

        /// <summary>
        /// The sort by column state.
        /// </summary>
        /// <param name="src">
        /// The src.
        /// </param>
        /// <returns>
        /// The <see cref="IEnumerable"/>.
        /// </returns>
        /// <exception cref="NotSupportedException">
        /// NotSupportedException
        /// </exception>
        private IEnumerable<FileInfo> SortByColumnState(IEnumerable<FileInfo> src)
        {
            System.Diagnostics.Debug.Assert(this.currentSortColumn != null, "this.currentSortColumn != null");

            switch (this.currentSortColumn.ColumnKinds)
            {
                case ColumnKinds.Name:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.IsDirectory == false).ThenBy(x => x.FileName)
                               : src.OrderByDescending(x => x.IsDirectory == false).ThenByDescending(x => x.FileName);

                case ColumnKinds.UpdateTimestamp:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.IsDirectory == false).ThenBy(x => x.UpdateTimestamp)
                               : src.OrderByDescending(x => x.IsDirectory == false)
                                     .ThenByDescending(x => x.UpdateTimestamp);

                case ColumnKinds.CreateTimestamp:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.IsDirectory == false).ThenBy(x => x.CreateTimestamp)
                               : src.OrderByDescending(x => x.IsDirectory == false)
                                     .ThenByDescending(x => x.CreateTimestamp);

                case ColumnKinds.FileKind:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.FileKind)
                               : src.OrderByDescending(x => x.FileKind);

                case ColumnKinds.ByteSize:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.ByteSize)
                               : src.OrderByDescending(x => x.ByteSize);

                case ColumnKinds.LabelColor:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.LabelColor)
                               : src.OrderByDescending(x => x.LabelColor);

                case ColumnKinds.Comment:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.Comment)
                               : src.OrderByDescending(x => x.Comment);

                case ColumnKinds.FileFullPath:
                    return (this.currentSortColumn.SortOrder == SortOrder.Ascending)
                               ? src.OrderBy(x => x.FileFullPath)
                               : src.OrderByDescending(x => x.FileFullPath);
            }

            throw new NotSupportedException();
        }

        /// <summary>
        /// The toggle sort.
        /// </summary>
        /// <param name="columnIndex">
        /// The column index.
        /// </param>
        private void ToggleSort(int columnIndex)
        {
            this.currentSortColumn =
                this.ColumnInfos.Values.Where(x => x.Visible).OrderBy(x => x.Index).Skip(columnIndex).First();

            this.currentSortColumn.ToggleSortOrder();

            this.SetColumnHeaderSortIcon(columnIndex, this.currentSortColumn.SortOrder);

            // 指定のカラム以外は無効
            for (var i = 0; i != this.Columns.Count; ++i)
            {
                if (i != columnIndex)
                {
                    this.SetColumnHeaderSortIcon(i, SortOrder.None);
                }
            }
        }

        #endregion
    }
}
