﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Dialog
{
    using System;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Data;
    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The child file select dialog.
    /// </summary>
    public partial class ChildFileSelectDialog : Form
    {
        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="ChildFileSelectDialog"/> class.
        /// </summary>
        /// <param name="directory">
        /// The directory.
        /// </param>
        /// <param name="fileKind">
        /// The file kind.
        /// </param>
        public ChildFileSelectDialog(string directory, FileKindType fileKind)
        {
            this.InitializeComponent();

            var name = Constants.FileKindInfos[fileKind].Name;

            this.Text = string.Format(this.Text, name);
            this.clhName.Text = string.Format(this.clhName.Text, name);

            RunOnIdleProcess.Execute(() =>
            {
                this.flvChildren.RequestUpdate(directory, fileKind);
                this.UpdateView();
            });
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets the selected file.
        /// </summary>
        public FileInfo SelectedFile { get; private set; }

        /// <summary>
        /// Gets or sets the text.
        /// </summary>
        public sealed override string Text
        {
            get
            {
                return base.Text;
            }

            set
            {
                base.Text = value;
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// The child file select form_ key down.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// イベント引数
        /// </param>
        private void ChildFileSelectForm_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Escape)
            {
                this.Close();
            }
        }

        /// <summary>
        /// The update view.
        /// </summary>
        private void UpdateView()
        {
            this.btnOk.Enabled = this.flvChildren.SelectedFile != null;

            this.flvChildren.GridLines = this.flvChildren.ItemsCount > 0;
        }

        /// <summary>
        /// The btn ok_ click.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// イベント引数
        /// </param>
        private void BtnOk_Click(object sender, EventArgs e)
        {
            this.SelectedFile = this.flvChildren.SelectedFile;
        }

        /// <summary>
        /// The flv children_ double click.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// イベント引数
        /// </param>
        private void FlvChildren_DoubleClick(object sender, EventArgs e)
        {
            if (this.flvChildren.SelectedFile != null)
            {
                this.SelectedFile = this.flvChildren.SelectedFile;
                this.DialogResult = DialogResult.OK;
                this.Close();
            }
        }

        /// <summary>
        /// The flv children_ selected index changed.
        /// </summary>
        /// <param name="sender">
        /// The sender.
        /// </param>
        /// <param name="e">
        /// イベント引数
        /// </param>
        private void FlvChildren_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.UpdateView();
        }

        #endregion
    }
}
