﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.AddressBar.DirBreadcrumbList
{
    using System;
    using System.Diagnostics.CodeAnalysis;
    using System.IO;
    using System.Linq;
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Data;
    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb dir breadcrumb list directory arrow.
    /// </summary>
    public class EBDirBreadcrumbListDirectoryArrow : EBDirBreadcrumbListArrow
    {
        #region Public Events

        /// <summary>
        /// The menu clicked.
        /// </summary>
        public event EventHandler MenuClicked;

        #endregion

        #region Methods

        /// <summary>
        /// The create dir list.
        /// </summary>
        /// <param name="param">
        /// The param.
        /// </param>
        /// <returns>
        /// The <see cref="ContextMenuStrip"/>.
        /// </returns>
        protected override ContextMenuStrip CreateDirList(object param)
        {
            System.Diagnostics.Debug.Assert(this.Parent is EBDirBreadcrumbListItemSet, "this.Parent is EBDirBreadcrumbListItemSet");
            System.Diagnostics.Debug.Assert(param is string, "param is string");

            var directory = param as string;

            if (PathUtility.EnumerateDirectories(directory).Any() == false)
            {
                return null;
            }

            var nextDepthDir = (this.Parent as EBDirBreadcrumbListItemSet).NextDepthDirectory;

            if (string.IsNullOrEmpty(nextDepthDir) == false)
            {
                nextDepthDir =
                    PathUtility.NormalizePathString((this.Parent as EBDirBreadcrumbListItemSet).NextDepthDirectory);
            }

            var cms = new ContextMenuStrip();

            cms.Items.AddRange(
                PathUtility.EnumerateDirectories(directory).Select(
                    x =>
                        {
                            var item = new ToolStripMenuItem
                                           {
                                               Text = Path.GetFileName(x),
                                               Image = Constants.FileKindInfos[FileKindType.Folder].Icon,
                                               Checked =
                                                   PathUtility.NormalizePathString(x) == nextDepthDir,
                                               Tag = x
                                           };

                            item.Click += (s, e) => this.MenuClicked(s, e);

                            return item;
                        }).Cast<ToolStripItem>().ToArray());

            return cms;
        }

        #endregion
    }
}
