﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;
using EffectMaker.BusinessLogic;
using EffectMaker.Foundation;
using EffectMaker.Foundation.Texture;
using EffectMaker.Foundation.Utility;
using EffectMaker.UIControls.Input;
using EffectMaker.UIControls.Specifics;
using EffectMaker.UIDialogs.Properties;
using WeifenLuo.WinFormsUI.Docking;

namespace EffectMaker.UIDialogs.TextureViewerDialog
{
    /// <summary>
    /// テクスチャ詳細ダイアログ
    /// </summary>
    public partial class TextureViewerDialog : WeifenLuo.WinFormsUI.Docking.DockContent
    {
        /// <summary>
        ///  コンストラクタ
        /// </summary>
        public TextureViewerDialog()
        {
            this.InitializeComponent();

            this.LastDockState = WeifenLuo.WinFormsUI.Docking.DockState.DockTop;
        }

        /// <summary>
        /// 対象ファイルパス
        /// </summary>
        public string TargetFilePath
        {
            get
            {
                return textureDetailPanel1.TargetFilePath;
            }

            set
            {
                textureDetailPanel1.TargetFilePath = value;

                // ウィンドウタイトル
                this.Text = string.Format(Resources.TextureViewerDialog_TitleCaption, this.TargetFilePath);
            }
        }

        /// <summary>
        /// チャンネル
        /// </summary>
        public ColorChannelFlags ColorChannel
        {
            get { return textureDetailPanel1.ColorChannel; }
            set { textureDetailPanel1.ColorChannel = value; }
        }

        /// <summary>
        /// フォームが閉じられる前のドックステート.
        /// </summary>
        public WeifenLuo.WinFormsUI.Docking.DockState LastDockState { get; set; }

        /// <summary>
        /// コマンドキーが押されたときの処理を処理を行います。
        /// </summary>
        /// <param name="msg">ウィンドウメッセージ</param>
        /// <param name="keyData">キー値</param>
        /// <returns>コマンドキーが処理された場合はtrue、それ以外の場合はfalseを返します。</returns>
        protected override bool ProcessCmdKey(ref Message msg, Keys keyData)
        {
            // フローティングウィンドウ時にグローバルなショートカットキー処理を行う
            if (this.DockState == DockState.Float)
            {
                GlobalKeyEventHandler.Instance.ProcessShortcut(keyData);
            }

            return base.ProcessCmdKey(ref msg, keyData);
        }

        /// <summary>
        /// フォームを閉じるときの前処理を行います。
        /// </summary>
        /// <param name="e">イベント情報</param>
        protected override void OnFormClosing(FormClosingEventArgs e)
        {
            base.OnFormClosing(e);

            // フォームを再利用するため、フォーム非表示にしてクローズ処理をキャンセルする
            this.Hide();
            e.Cancel = true;

            this.textureDetailPanel1.ResetSettings();
        }
    }
}
