﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;

namespace EffectMaker.UIDialogs.SearchDialog
{
    public partial class UISearchCombination : UIUserControl
    {
        public UISearchCombination()
        {
            InitializeComponent();
            //this.Setup();
        }

        public string ID
        {
            get { return this.txbTitle.Text; }
        }

        public string Lhs
        {
            get { return this.cbxLeft.Items[this.cbxLeft.SelectedIndex].ToString(); }
        }

        public string Rhs
        {
            get { return this.cbxRight.Items[this.cbxRight.SelectedIndex].ToString(); }
        }

        public string Operator
        {
            get { return this.cbxOperator.Items[this.cbxOperator.SelectedIndex].ToString(); }
        }

        public void AddRightItem(string text)
        {
            this.cbxRight.Items.Add(text);
        }

        public void AddLeftItem(string text)
        {
            this.cbxLeft.Items.Add(text);
        }

        public void SetTitle(string text)
        {
            this.txbTitle.Text = text;
        }

        public void Setup()
        {
            this.cbxOperator.Items.Add("AND");
            this.cbxOperator.Items.Add("OR");

            this.cbxRight.SelectedIndex = 0;
            this.cbxLeft.SelectedIndex = 0;
            this.cbxOperator.SelectedIndex = 0;
        }
    }
}
