﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace EffectMaker.UIDialogs.SearchDialog
{
    public enum SearchCombinationOperation
    {
        And,
        Or,
    }

    public class SearchTree
    {

        public SearchTree Lhs { get; set; } = null;

        public SearchTree Rhs { get; set; } = null;

        public SearchCondition Condition { get; set; }

        public SearchCombinationOperation Operation { get; set; } = SearchCombinationOperation.And;

        public SearchLogger Logger { get; set; }

        public bool Evaluate(XmlNode node)
        {
            if (Condition != null)
            {
                return this.Condition.Evaluate(node, this.Logger);
            }

            if (this.Lhs == null)
            {
                throw new System.InvalidOperationException("SearchTree is not setup.");
            }

            if (this.Rhs == null)
            {
                throw new System.InvalidOperationException("SearchTree is not setup.");
            }

            if (this.Operation == SearchCombinationOperation.And)
            {
                return this.Lhs.Evaluate(node) && this.Rhs.Evaluate(node);
            }
            else
            {
                return this.Lhs.Evaluate(node) || this.Rhs.Evaluate(node);
            }
        }

        public void Dump()
        {
            if (this.Logger == null)
            {
                return;
            }

            this.Logger.Log("Dumping tree.");

            this.Dump(this, 1);
        }

        private void Dump(SearchTree tree, int depth)
        {
            string indent = new string(' ', depth * 2);

            if (tree.Condition != null)
            {
                this.Logger.Log(indent + tree.Condition.XPath + " " + tree.Condition.Value);
                return;
            }

            if (tree.Lhs != null)
            {
                this.Logger.Log(indent + "Lhs");
                this.Dump(tree.Lhs, depth + 1);
            }

            if (tree.Rhs != null)
            {
                this.Logger.Log(indent + "Rhs");
                this.Dump(tree.Rhs, depth + 1);
            }
        }

        public void SetupChildren()
        {
            this.Lhs = new SearchTree();
            this.Rhs = new SearchTree();
            this.Lhs.Logger = this.Logger;
            this.Rhs.Logger = this.Logger;
        }
    }

    public class SearchTreeBuilder
    {
        public SearchTree Build(UISearchCombination panel)
        {
            SearchTree tree = new SearchTree();


            return tree;
        }
    }
}
