﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Resources;
using System.Runtime.Versioning;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIDialogs.Properties;

namespace EffectMaker.UIDialogs.MessageDialogs
{
    /// <summary>
    /// ファイル上書きコピー時の確認ダイアログです。
    /// </summary>
    public partial class OverwriteAssetDialog : Form
    {
        /// <summary>
        /// The labels tool tip.
        /// </summary>
        private ToolTip labelsToolTip;

        /// <summary>
        /// コンストラクタです。引数にファイルパスと日時を指定します。
        /// </summary>
        /// <param name="srcPath">
        /// コピー元のファイルパス
        /// </param>
        /// <param name="srcModTime">
        /// コピー元ファイルの更新日時
        /// </param>
        /// <param name="dstPath">
        /// コピー先のファイルパス
        /// </param>
        /// <param name="dstModTime">
        /// コピー先ファイルの更新日時
        /// </param>
        public OverwriteAssetDialog(string srcPath, DateTime srcModTime, string dstPath, DateTime dstModTime)
        {
            this.InitializeComponent();
            this.picture_icon.Image = SystemIcons.Warning.ToBitmap();

            this.labelsToolTip = new System.Windows.Forms.ToolTip(new System.ComponentModel.Container());

            this.Text = Resources.OverwriteAssetDialogCaption;
            this.label_description.Text = Resources.OverwriteAssetDialogDescription;
            this.label_src.Text = Resources.OverwriteAssetDialogSource;
            this.label_src_filename.Text = Resources.OverwriteAssetDialogFileName;
            this.label_src_timestamp.Text = Resources.OverwriteAssetDialogTimeStamp;
            this.label_dst.Text = Resources.OverwriteAssetDialogDestination;
            this.label_dst_filename.Text = Resources.OverwriteAssetDialogFileName;
            this.label_dst_timestamp.Text = Resources.OverwriteAssetDialogTimeStamp;
            this.btnYes.Text = Resources.DialogButtonYes;
            this.btnNo.Text = Resources.DialogButtonNo;
            this.btnCancel.Text = Resources.DialogButtonCancel;

            this.PreparePathLabel(this.label_src_filename_view, srcPath);
            this.PrepareDateLabel(this.label_src_timestamp_view, srcModTime);

            this.PreparePathLabel(this.label_dst_filename_view, dstPath);
            this.PrepareDateLabel(this.label_dst_timestamp_view, dstModTime);
        }

        /// <summary>
        /// フォームのキャプションに対するsealedプロパティです。
        /// </summary>
        public override sealed string Text
        {
            get { return base.Text; }
            set { base.Text = value; }
        }

        /// <summary>
        /// ファイルパスをラベルにセットし、ツールチップにセットします。
        /// </summary>
        /// <param name="pathLabel">
        /// ファイルパスをセットするラベル
        /// </param>
        /// <param name="path">
        /// セットするファイルパス
        /// </param>
        private void PreparePathLabel(UILabel pathLabel, string path)
        {
            pathLabel.Text = path;
            this.labelsToolTip.SetToolTip(pathLabel, path);
        }

        /// <summary>
        /// 更新日時をラベルにセットし、ツールチップにセットします。
        /// </summary>
        /// <param name="dateLabel">
        /// 更新日時をセットするラベル
        /// </param>
        /// <param name="date">
        /// セットする更新日時
        /// </param>
        private void PrepareDateLabel(UILabel dateLabel, DateTime date)
        {
            string dateString = date.ToShortDateString() + " " + date.ToShortTimeString();
            dateLabel.Text = dateString;
        }
    }
}
