﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using EffectMaker.Foundation.Render.Layout;

namespace EffectMaker.UIControls.Layout
{
    /// <summary>
    /// Interface for element that can take part in a layout process.
    /// </summary>
    public interface ILayoutElement : IControl
    {
        /// <summary>
        /// Called when the Visible property changes.
        /// </summary>
        event EventHandler VisibleChanged;

        /// <summary>
        /// Gets or sets the visibility of the element.
        /// See ControlExtender for more information.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        Visibility Visibility { get; set; }

        /// <summary>
        /// Gets or sets the horizontal alignment of the element.
        /// See ControlExtender for more information.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        HAlignment HorizontalAlignment { get; set; }

        /// <summary>
        /// Gets or sets the vertical alignment of the element.
        /// See ControlExtender for more information.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        VAlignment VerticalAlignment { get; set; }

        /// <summary>
        /// Gets or sets the external margin of the element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        Padding Margin { get; set; }

        /// <summary>
        /// Gets or sets the auto sizing flag.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        bool AutoSize { get; set; }

        /// <summary>
        /// The X location of the layout element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        int Left { get; set; }

        /// <summary>
        /// The Y location of the layout element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        int Top { get; set; }

        /// <summary>
        /// The location of the layout element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        Point Location { get; set; }

        /// <summary>
        /// The width of the layout element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        int Width { get; set; }

        /// <summary>
        /// The height of the layout element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        int Height { get; set; }

        /// <summary>
        /// The size of the layout element.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        Size Size { get; set; }

        /// <summary>
        /// Location + Size
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        Rectangle Bounds { get; set; }

        /// <summary>
        /// VisibilityがCollapsedになった時に元のサイズを覚えておくためのプロパティ
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        Size OriginalSize { get; set; }

        /// <summary>
        /// Gets or sets the flag that tells whether the element is visible or not.
        /// </summary>
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]
        bool Visible { get; set; }

        /// <summary>
        /// Gets the size the control want or need to have, according to a given available space.
        /// </summary>
        /// <param name="proposedSize">The available space.</param>
        /// <returns>Returns the desired size.</returns>
        Size GetPreferredSize(Size proposedSize);

        /// <summary>
        /// Request a layout phase to be performed.
        /// </summary>
        void PerformLayout();
    }
}
