﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using EffectMaker.Foundation.Interfaces;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// A base IIndexableCollection implementation.
    /// </summary>
    /// <typeparam name="T">The type of subjacent items.</typeparam>
    public abstract class IndexableCollectionBase<T> : IIndexableCollection<T>
    {
        /// <summary>
        /// Gets the number of item in the collection.
        /// </summary>
        public abstract int Count { get; }

        /// <summary>
        /// Returns false.
        /// </summary>
        public virtual bool IsReadOnly
        {
            get { return false; }
        }

        /// <summary>
        /// Gets an item at a given index.
        /// </summary>
        /// <param name="index">Index of the item.</param>
        /// <returns>Returns the item at the given index.</returns>
        public abstract T this[int index] { get; }

        /// <summary>
        /// Adds an item.
        /// </summary>
        /// <param name="item">Item to add.</param>
        public abstract void Add(T item);

        /// <summary>
        /// Clears all items.
        /// </summary>
        public abstract void Clear();

        /// <summary>
        /// Check whether an item exists in the collection.
        /// </summary>
        /// <param name="item">The item to check.</param>
        /// <returns>Returns true if the item is present, false otherwise.</returns>
        public abstract bool Contains(T item);

        /// <summary>
        /// Not implemented.
        /// </summary>
        /// <param name="array">The parameter is not used.</param>
        /// <param name="arrayIndex">The parameter is not used.</param>
        public virtual void CopyTo(T[] array, int arrayIndex)
        {
            throw new NotSupportedException();
        }

        /// <summary>
        /// Removes an item from the collection.
        /// </summary>
        /// <param name="item">The item to remove.</param>
        /// <returns>Returns true when the item is removed/removable, false otherwise.</returns>
        public abstract bool Remove(T item);

        /// <summary>
        /// Gets an enumerator of the items sequence.
        /// </summary>
        /// <returns>Returns the items sequence enumerator.</returns>
        public abstract IEnumerator<T> GetEnumerator();

        /// <summary>
        /// Gets an enumerator of the items sequence.
        /// </summary>
        /// <returns>Returns the items sequence enumerator.</returns>
        System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }
    }

    /// <summary>
    /// An indexable collection.
    /// </summary>
    /// <typeparam name="T">Type of subjacent elements.</typeparam>
    public class IndexableCollection<T> : Collection<T>, IIndexableCollection<T>
    {
    }
}
