﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EffectMaker.UIControls
{
    /// <summary>
    /// Represent a control that can contain child item controls.
    /// </summary>
    public interface IItemsControl : IControl
    {
        /// <summary>
        /// Gets or sets the data source for items.
        /// </summary>
        IEnumerable ItemsSource { get; set; }

        /// <summary>
        /// Gets or sets the type of container to automatically create.
        /// </summary>
        Type ItemContainerType { get; set; }

        /// <summary>
        /// Gets or sets the item container selector.
        /// </summary>
        IItemContainerSelector ItemContainerSelector { get; set; }

        /// <summary>
        /// Compares two child controls for sorting.
        /// </summary>
        /// <param name="a">First control.</param>
        /// <param name="b">Second control.</param>
        /// <returns>Returns 0 if equal, 1 or -1 if different depending on order.</returns>
        int CompareControls(IControl a, IControl b);

        /// <summary>
        /// Retrieve the data item corresponding to the container.
        /// </summary>
        /// <param name="container">The container to look for its data item.</param>
        /// <returns>Returns the data item, or null if not found.</returns>
        object GetDataItemFromContainer(IControl container);

        /// <summary>
        /// Retrieve the container corresponding to the data item.
        /// </summary>
        /// <param name="dataItem">The data item to look for its data.</param>
        /// <returns>Returns the container, or null if not found.</returns>
        IControl GetContainerFromDataItem(object dataItem);
    }
}
