﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace EffectMaker.UIControls.Extensions
{
    /// <summary>
    /// Extensions methods related to the Rectangle structure.
    /// </summary>
    public static class RectangleExtensions
    {
        /// <summary>
        /// Augment a rectangle by applying a padding to it.
        /// </summary>
        /// <param name="rect">The original rectangle.</param>
        /// <param name="padding">The padding to add.</param>
        /// <returns>Returns a new rectangle with the padding added.</returns>
        public static Rectangle AddPadding(this Rectangle rect, Padding padding)
        {
            return new Rectangle(
                rect.Left - padding.Left,
                rect.Top - padding.Top,
                rect.Width + padding.Horizontal,
                rect.Height + padding.Vertical);
        }

        /// <summary>
        /// Reduce a rectangle by applying a padding to it.
        /// </summary>
        /// <param name="rect">The original rectangle.</param>
        /// <param name="padding">The padding to remove.</param>
        /// <returns>Returns a new rectangle with the padding removed.</returns>
        public static Rectangle RemovePadding(this Rectangle rect, Padding padding)
        {
            return new Rectangle(
                rect.Left + padding.Left,
                rect.Top + padding.Top,
                rect.Width - padding.Horizontal,
                rect.Height - padding.Vertical);
        }
    }
}
