﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.UIControls.EventArguments
{
    /// <summary>
    /// Event argument class for the pre-filter mouse events.
    /// </summary>
    public class PreFilterMouseEventArgs : MouseEventArgs
    {
        /// <summary>
        /// Contructor.
        /// </summary>
        /// <param name="buttons">ボタンの種類</param>
        /// <param name="clicks">クリック回数</param>
        /// <param name="x">X座標</param>
        /// <param name="y">Y座標</param>
        /// <param name="delta">ホイール回転数</param>
        public PreFilterMouseEventArgs(MouseButtons buttons, int clicks, int x, int y, int delta) :
            base(buttons, clicks, x, y, delta)
        {
            this.Filter = false;
        }

        /// <summary>
        /// Get or set the flag indicating whether to filter the event and stop it
        /// from being dispatched.
        /// </summary>
        public bool Filter { get; set; }
    }
}
