﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Windows.Forms;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// コンテキストメニューユティリティ
    /// </summary>
    public static class ContextMenuUtility
    {
        /// <summary>
        ///  コピー、貼り付けコンテキストメニュー コピーメニューインデックス
        /// </summary>
        public const int CopyPasteMenuCopyIndex = 0;

        /// <summary>
        ///  コピー、貼り付けコンテキストメニュー 貼り付けメニューインデックス
        /// </summary>
        public const int CopyPasteMenuPasteIndex = 1;

        /// <summary>
        /// コピー、貼り付けコンテキストメニューを作る
        /// </summary>
        /// <param name="onCopy">コピークリック時処理</param>
        /// <param name="onPaste">貼り付けクリック時処理</param>
        /// <returns>コンテキストメニュー</returns>
        public static ContextMenuStrip CreateCopyPaste(Action onCopy, Action onPaste)
        {
            var cms = new ContextMenuStrip();

            cms.Items.Add(CreateMenuItem(Properties.Resources.ContextMenuCopy, onCopy));
            cms.Items.Add(CreateMenuItem(Properties.Resources.ContextMenuPaste, onPaste));

            return cms;
        }

        /// <summary>
        /// メニューアイテムを作る
        /// </summary>
        /// <param name="text">テキスト</param>
        /// <param name="action">クリック時処理</param>
        /// <returns>メニューアイテム</returns>
        private static ToolStripMenuItem CreateMenuItem(string text, Action action)
        {
            var menu = new ToolStripMenuItem
            {
                Text = text
            };

            if (action != null)
            {
                menu.Click += (s, e) => action();
            }

            return menu;
        }
    }
}
