﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using EffectMaker.Foundation.Primitives;

namespace EffectMaker.UIControls.Specifics.ColorPicker
{
    /// <summary>
    /// カラー編集モード。
    /// </summary>
    public enum ColorEditMode
    {
        /// <summary>ＲＧＢＡ。</summary>
        RGBA,

        /// <summary>ＲＧＢ成分のみ。</summary>
        RGB,

        /// <summary>Ａ成分のみ。</summary>
        A,
    }

    /// <summary>
    /// Interface for controls to be able to connect to the color picker panel.
    /// </summary>
    public interface IColorPickerConnectable
    {
        /// <summary>
        /// Get the color edit mode.
        /// </summary>
        ColorEditMode ColorEditMode { get; }

        /// <summary>
        /// Set the color picker for editing gradation keys.
        /// </summary>
        /// <param name="colorPicker">The color picker.</param>
        void SetColorPicker(IColorKeyEditor colorPicker);

        /// <summary>
        /// Unset the color picker target if the active target is this control.
        /// </summary>
        void UnsetColorPickerTarget();

        /// <summary>
        /// Check if any key being selected.
        /// </summary>
        /// <returns>True if any key is selected.</returns>
        bool IsKeySelected();

        /// <summary>
        /// Check if the selected key time is fixed.
        /// </summary>
        /// <returns>True if the selected key time is fixed.</returns>
        bool IsSelectedKeyTimeFixed();

        /// <summary>
        /// Set selected key color.
        /// </summary>
        /// <param name="color">The color to set.</param>
        /// <param name="isChanging">True if the value has not finished modifying.</param>
        void SetSelectedKeyColor(ColorRgba color, bool isChanging);

        /// <summary>
        /// Get selected key color.
        /// </summary>
        /// <returns>The color.</returns>
        ColorRgba GetSelectedKeyColor();

        /// <summary>
        /// Set selected key time.
        /// </summary>
        /// <param name="time">The time to set.</param>
        /// <param name="isChanging">True if the value has not finished modifying.</param>
        /// <returns>The actual key time after the specified time is verified.</returns>
        int SetSelectedKeyTime(int time, bool isChanging);

        /// <summary>
        /// Get selected key time.
        /// </summary>
        /// <returns>The selected key time.</returns>
        int GetSelectedKeyTime();
    }
}
