﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using EffectMaker.UIControls.BaseControls;
using EffectMaker.UIControls.DataBinding;
using EffectMaker.UIControls.Specifics.Sliders;

namespace EffectMaker.UIControls.Specifics
{
    /// <summary>
    /// 係数アニメーションキーフレームエディタ
    /// </summary>
    public partial class CoefficientAnimationKeyFrameEditor : UIUserControl
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CoefficientAnimationKeyFrameEditor()
        {
            this.InitializeComponent();

            // 時間ラベルと値ラベル
            this.uiLabel1.Text = Properties.Resources.CoefficientAnimationKeyFrameEditorLabelTime;
            this.uiLabel2.Text = Properties.Resources.CoefficientAnimationKeyFrameEditorLabelValue;

            this.dslTime.Deformat = src =>
            {
                src = src.Trim();

                // 文字列最後のパーセント記号を削る
                if (src.Substring(src.Length - 1, 1) == "%")
                {
                    src = src.Substring(0, src.Length - 1);
                }

                return src;
            };
        }

        /// <summary>
        /// 編集中時間
        /// </summary>
        public int EditingTime
        {
            get
            {
                return this.Time;
            }

            set
            {
            }
        }

        /// <summary>
        /// 編集中値
        /// </summary>
        public float EditingValue
        {
            get
            {
                return this.Value;
            }

            set
            {
            }
        }

        /// <summary>
        /// 時間
        /// </summary>
        public int Time
        {
            get
            {
                return (int)this.dslTime.Value;
            }

            set
            {
                this.dslTime.Value = value;
                this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "Time");
            }
        }

        /// <summary>
        /// 値
        /// </summary>
        public float Value
        {
            get
            {
                return this.dslValue.Value;
            }

            set
            {
                this.dslValue.Value = value;
                this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "Value");
            }
        }

        /// <summary>
        /// 時間のテキストが変わった
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The event arguments.</param>
        private void ValueChanged_dslTime(object sender, System.EventArgs e)
        {
            this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "Time");
        }

        /// <summary>
        /// 値のテキストが変わった
        /// </summary>
        /// <param name="sender">The sender.</param>
        /// <param name="e">The event arguments.</param>
        private void ValueChanged_dslValue(object sender, System.EventArgs e)
        {
            this.LogicalTreeElementExtender.NotifyPropertyChanged(BindingUpdateType.PropertyChanged, "Value");
        }

        /// <summary>
        /// アジャストボタン押下時
        /// </summary>
        /// <param name="sender">呼び出し元</param>
        /// <param name="e">イベント引数</param>
        private void AdjElement1_Click(object sender, System.EventArgs e)
        {
            this.Value = UtilDialSlider.Round(this.Value);
        }
    }
}
