﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Xml.Serialization;
using EffectMaker.Foundation.Serialization;

namespace EffectMaker.ObsoleteUserDataConverter.ObsoleteUserData
{
    /// <summary>
    /// The integer slider definition serializer for .udd/.usd files.
    /// </summary>
    [Serializable]
    public class IntSliderDefinition : UserDefinitionBase
    {
        /// <summary>The default value for MinValue property.</summary>
        private const int DefaultMinValueValue = -1000000;

        /// <summary>The default value for MaxValue property.</summary>
        private const int DefaultMaxValueValue = 1000000;

        /// <summary>The default value for DefaultValue property.</summary>
        private const int DefaultDefaultValueValue = 0;

        /// <summary>The default value for DeltaLevel property.</summary>
        private const int DefaultDeltaLevelValue = 3;

        /// <summary>
        /// Static constructor.
        /// </summary>
        static IntSliderDefinition()
        {
            Type myType = typeof(IntSliderDefinition);

            UserDefinitionBase.RegisterSmartProperty(myType.GetProperty("MinValue"), DefaultMinValueValue);
            UserDefinitionBase.RegisterSmartProperty(myType.GetProperty("MaxValue"), DefaultMaxValueValue);
            UserDefinitionBase.RegisterSmartProperty(myType.GetProperty("DefaultValue"), DefaultDefaultValueValue);
            UserDefinitionBase.RegisterSmartProperty(myType.GetProperty("DeltaLevel"), DefaultDeltaLevelValue);
        }

        /// <summary>
        /// Default constructor.
        /// </summary>
        public IntSliderDefinition() :
            base()
        {
        }

        /// <summary>
        /// Get or set the minimum value.
        /// </summary>
        [XmlAttribute("MinMaxRange")]
        public int MinValue
        {
            get { return this.GetSmartPropertyValue(() => this.MinValue); }
            set { this.SetSmartPropertyValue(() => this.MinValue, value); }
        }

        /// <summary>
        /// Get or set the maximum value.
        /// </summary>
        [XmlAttribute("MaxMaxRange")]
        public int MaxValue
        {
            get { return this.GetSmartPropertyValue(() => this.MaxValue); }
            set { this.SetSmartPropertyValue(() => this.MaxValue, value); }
        }

        /// <summary>
        /// Get or set the default value.
        /// </summary>
        [XmlAttribute("Default")]
        public int DefaultValue
        {
            get { return this.GetSmartPropertyValue(() => this.DefaultValue); }
            set { this.SetSmartPropertyValue(() => this.DefaultValue, value); }
        }

        /// <summary>
        /// Get or set the default value.
        /// </summary>
        [XmlAttribute("DeltaLevel")]
        public int DeltaLevel
        {
            get { return this.GetSmartPropertyValue(() => this.DeltaLevel); }
            set { this.SetSmartPropertyValue(() => this.DeltaLevel, value); }
        }

        /// <summary>
        /// Deserializes from the given XML node.
        /// </summary>
        /// <param name="context">The data context needed for the deserialization.</param>
        /// <returns>True on success.</returns>
        public override bool ReadXml(XmlDocSerializationContext context)
        {
            if (base.ReadXml(context) == false)
            {
                return false;
            }

            if (this.HasAttribute(context, "MinMaxRange") == true)
            {
                this.MinValue = this.ReadAttribute(context, "MinMaxRange", DefaultMinValueValue);
            }

            if (this.HasAttribute(context, "MaxMaxRange") == true)
            {
                this.MaxValue = this.ReadAttribute(context, "MaxMaxRange", DefaultMaxValueValue);
            }

            if (this.HasAttribute(context, "Default") == true)
            {
                this.DefaultValue = this.ReadAttribute(context, "Default", DefaultDefaultValueValue);
            }

            if (this.HasAttribute(context, "DeltaLevel") == true)
            {
                this.DeltaLevel = this.ReadAttribute(context, "DeltaLevel", DefaultDeltaLevelValue);
            }

            return true;
        }

        /// <summary>
        /// Apply template to the definition.
        /// </summary>
        /// <param name="template">The template.</param>
        public override void ApplyTemplate(TemplateDefinition template)
        {
            base.ApplyTemplate(template);

            template.ApplyTemplateValue(this, "MinValue");
            template.ApplyTemplateValue(this, "MaxValue");
            template.ApplyTemplateValue(this, "DefaultValue");
            template.ApplyTemplateValue(this, "DeltaLevel");
        }
    }
}
