﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    using System;
    using System.ComponentModel;

    /// <summary>
    /// 行列のインターフェースです。
    /// </summary>
    public interface IMatrix : ICloneable, INotifyPropertyChanged, ISettable
    {
        /// <summary>
        /// 行数を取得します。
        /// </summary>
        int RowCount { get; }

        /// <summary>
        /// 列数をを取得します。
        /// </summary>
        int ColumnCount { get; }

        /// <summary>
        /// 行成分のベクトル列を取得します。
        /// </summary>
        IVector[] Rows { get; }

        /// <summary>
        /// 列成分のベクトル列を取得します。
        /// </summary>
        IVector[] Columns { get; }

        /// <summary>
        /// 指定したインデックス位置の成分へのアクセスを行うインデクサです。
        /// </summary>
        /// <param name="row">アクセスする成分の行の 0 から始まるインデックスです。</param>
        /// <param name="column">アクセスする成分の列の 0 から始まるインデックスです。</param>
        /// <returns>指定したインデックス位置の成分です。</returns>
        float this[int row, int column] { get; set; }

        /// <summary>
        /// 行列の成分を全て 0 に設定します。
        /// </summary>
        void SetZero();

        /// <summary>
        /// 単位行列に設定します。
        /// </summary>
        void SetIdentity();

        /// <summary>
        /// 要素を格納した配列を返します。
        /// </summary>
        /// <returns>要素の配列です。</returns>
        float[] ToArray();
    }
}
