﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit
{
    /// <summary>
    /// カラーユーティリティです。
    /// </summary>
    public static class ColorUtility
    {
       /// <summary>
        /// 指定した IColor に値を設定します。
        /// </summary>
        /// <param name="color">IColor です。</param>
        /// <param name="r">設定する R 成分です。</param>
        /// <param name="g">設定する G 成分です。</param>
        /// <param name="b">設定する B 成分です。</param>
        /// <param name="a">設定する A 成分です。</param>
        public static void Set(IColor color, float r, float g, float b, float a)
        {
            color.Set(new RgbaColor(r, g, b, a));
        }
    }
}
