﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Xml
{
    using System.Xml.Serialization;
    using NintendoWare.ToolDevelopmentKit.Conversion;

    /// <summary>
    /// 3 × 3 行列を表します。
    /// </summary>
    [CoupledType(typeof(Matrix33))]
    public class Matrix33Xml : ISettable
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Matrix33Xml()
        {
        }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M00 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M01 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M02 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M10 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M11 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M12 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M20 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M21 { get; set; }

        /// <summary>行列の成分を取得または設定します。</summary>
        [XmlAttribute]
        public float M22 { get; set; }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        public void Set(object source)
        {
            this.Set(source as Matrix33Xml);
        }

        /// <summary>
        /// オブジェクトを設定します。
        /// </summary>
        /// <param name="source">設定するオブジェクトです。</param>
        protected void Set(Matrix33Xml source)
        {
            Ensure.Argument.NotNull(source);

            this.M00 = source.M00;
            this.M01 = source.M01;
            this.M02 = source.M02;

            this.M10 = source.M10;
            this.M11 = source.M11;
            this.M12 = source.M12;

            this.M20 = source.M20;
            this.M21 = source.M21;
            this.M22 = source.M22;
        }
    }
}
