﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.ToolDevelopmentKit.Logs
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// ログを収集するログコレクタのインターフェースです。
    /// </summary>
    public interface ILogCollector : ICloneable
    {
        //-----------------------------------------------------------------
        // プロパティの取得または設定
        //-----------------------------------------------------------------

        /// <summary>
        /// ログ収集対象のロガーを取得または設定します。
        /// </summary>
        ILogger Logger { get; set; }

        //-----------------------------------------------------------------

        /// <summary>
        /// 致命的な障害ログのログリストです。
        /// </summary>
        IList<ILog> Fatal { get; }

        /// <summary>
        /// エラーログのログリストです。
        /// </summary>
        IList<ILog> Error { get; }

        /// <summary>
        /// 警告ログのログリストです。
        /// </summary>
        IList<ILog> Warn { get; }

        /// <summary>
        /// 情報ログのログリストです。
        /// </summary>
        IList<ILog> Info { get; }

        /// <summary>
        /// デバッグ用ログのログリストです。
        /// </summary>
        IList<ILog> Debug { get; }

        //-----------------------------------------------------------------
        // 収集したログへのアクセス
        //-----------------------------------------------------------------

        /// <summary>
        /// 収集したログをクリアします。
        /// </summary>
        void Clear();

        /// <summary>
        /// ログを持っているかどうかを返します。
        /// </summary>
        /// <returns>ログを持っている場合に true を返します。</returns>
        bool HasLog();

        /// <summary>
        /// 致命的な障害かエラーがあるかどうかを返します。
        /// </summary>
        /// <returns>致命的な障害かエラーがある場合に true を返します。</returns>
        bool HasFatalOrErrorLog();

        /// <summary>
        /// 致命的な障害かエラーか警告があるかどうかを返します。
        /// </summary>
        /// <returns>致命的な障害かエラーか警告がある場合に true を返します。</returns>
        bool HasFatalOrErrorOrWarnLog();
    }
}
