﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Xml.Serialization;
using NintendoWare.ToolDevelopmentKit;
using NintendoWare.ToolDevelopmentKit.Conversion;
using NintendoWare.ToolDevelopmentKit.Xml;
using NWCore.DataModel.Major_1.Minor_4.Build_0.Revision_0;

namespace NWCore.Serializer.Major_1.Minor_4.Build_0.Revision_0
{
    /// <summary>
    /// 編集データ：EmitterSet用（シリアライズ用）
    /// </summary>
    [CoupledType(typeof(EditDataEmitterSet))]
    public class EditDataEmitterSetXml : EditDataXml
    {
        EditDataEmitterSet m_data;

        #region 初期化

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditDataEmitterSetXml()
        {
            m_data = new EditDataEmitterSet();
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public EditDataEmitterSetXml(EditDataEmitterSet data)
            : this()
        {
            m_data.Set(data);
        }

        #endregion

        #region Property

        /// <summary
        /// データ
        /// </summary>
        public override BaseEditData EditData
        {
            get { return m_data; }
        }

        /// <summary>
        /// コメント
        /// </summary>
        public string Comment
        {
            get { return m_data.Comment; }
            set { m_data.Comment = value; }
        }

        /// <summary>
        /// カラーラベル
        /// </summary>
        public int ColorLabelIndex
        {
            get { return m_data.ColorLabelIndex; }
            set { m_data.ColorLabelIndex = value; }
        }

        #endregion
    }
}
